/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.plugins.accesscontrol;

import com.sun.jersey.spi.container.ContainerRequest;
import de.deepamehta.core.Association;
import de.deepamehta.core.AssociationType;
import de.deepamehta.core.DeepaMehtaObject;
import de.deepamehta.core.RelatedTopic;
import de.deepamehta.core.Topic;
import de.deepamehta.core.TopicType;
import de.deepamehta.core.Type;
import de.deepamehta.core.ViewConfiguration;
import de.deepamehta.core.model.ChildTopicsModel;
import de.deepamehta.core.model.SimpleValue;
import de.deepamehta.core.model.TopicModel;
import de.deepamehta.core.osgi.PluginActivator;
import de.deepamehta.core.service.DeepaMehtaEvent;
import de.deepamehta.core.service.EventListener;
import de.deepamehta.core.service.Inject;
import de.deepamehta.core.service.Transactional;
import de.deepamehta.core.service.event.AllPluginsActiveListener;
import de.deepamehta.core.service.event.IntroduceAssociationTypeListener;
import de.deepamehta.core.service.event.IntroduceTopicTypeListener;
import de.deepamehta.core.service.event.PostCreateAssociationListener;
import de.deepamehta.core.service.event.PostCreateTopicListener;
import de.deepamehta.core.service.event.PostUpdateTopicListener;
import de.deepamehta.core.service.event.PreSendAssociationTypeListener;
import de.deepamehta.core.service.event.PreSendTopicTypeListener;
import de.deepamehta.core.service.event.ResourceRequestFilterListener;
import de.deepamehta.core.service.event.ServiceRequestFilterListener;
import de.deepamehta.core.storage.spi.DeepaMehtaTransaction;
import de.deepamehta.core.util.DeepaMehtaUtils;
import de.deepamehta.core.util.JavaUtils;
import de.deepamehta.plugins.accesscontrol.event.PostLoginUserListener;
import de.deepamehta.plugins.accesscontrol.event.PostLogoutUserListener;
import de.deepamehta.plugins.accesscontrol.model.ACLEntry;
import de.deepamehta.plugins.accesscontrol.model.AccessControlList;
import de.deepamehta.plugins.accesscontrol.model.Credentials;
import de.deepamehta.plugins.accesscontrol.model.Operation;
import de.deepamehta.plugins.accesscontrol.model.Permissions;
import de.deepamehta.plugins.accesscontrol.model.UserRole;
import de.deepamehta.plugins.accesscontrol.service.AccessControlService;
import de.deepamehta.plugins.workspaces.service.WorkspacesService;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/accesscontrol")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AccessControlPlugin
extends PluginActivator
implements AccessControlService,
AllPluginsActiveListener,
PostCreateTopicListener,
PostCreateAssociationListener,
PostUpdateTopicListener,
IntroduceTopicTypeListener,
IntroduceAssociationTypeListener,
ServiceRequestFilterListener,
ResourceRequestFilterListener,
PreSendTopicTypeListener,
PreSendAssociationTypeListener {
    private static final boolean READ_REQUIRES_LOGIN = Boolean.parseBoolean(System.getProperty("dm4.security.read_requires_login", "false"));
    private static final boolean WRITE_REQUIRES_LOGIN = Boolean.parseBoolean(System.getProperty("dm4.security.write_requires_login", "true"));
    private static final String SUBNET_FILTER = System.getProperty("dm4.security.subnet_filter", "127.0.0.1/32");
    private static final String AUTHENTICATION_REALM = "DeepaMehta";
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "";
    private static final AccessControlList DEFAULT_INSTANCE_ACL = new AccessControlList(new ACLEntry(Operation.WRITE, UserRole.CREATOR, UserRole.OWNER, UserRole.MEMBER));
    private static final AccessControlList DEFAULT_TYPE_ACL = new AccessControlList(new ACLEntry(Operation.WRITE, UserRole.CREATOR, UserRole.OWNER, UserRole.MEMBER), new ACLEntry(Operation.CREATE, UserRole.CREATOR, UserRole.OWNER, UserRole.MEMBER));
    private static final AccessControlList DEFAULT_USER_ACCOUNT_ACL = new AccessControlList(new ACLEntry(Operation.WRITE, UserRole.CREATOR, UserRole.OWNER));
    private static String URI_CREATOR = "dm4.accesscontrol.creator";
    private static String URI_OWNER = "dm4.accesscontrol.owner";
    private static String URI_ACL = "dm4.accesscontrol.acl";
    private static DeepaMehtaEvent POST_LOGIN_USER = new DeepaMehtaEvent(PostLoginUserListener.class){

        public void deliver(EventListener listener, Object ... params) {
            ((PostLoginUserListener)listener).postLoginUser((String)params[0]);
        }
    };
    private static DeepaMehtaEvent POST_LOGOUT_USER = new DeepaMehtaEvent(PostLogoutUserListener.class){

        public void deliver(EventListener listener, Object ... params) {
            ((PostLogoutUserListener)listener).postLogoutUser((String)params[0]);
        }
    };
    @Inject
    private WorkspacesService wsService;
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @POST
    @Path(value="/login")
    public void login() {
    }

    @Override
    @POST
    @Path(value="/logout")
    public void logout() {
        this._logout(this.request);
        if (READ_REQUIRES_LOGIN) {
            this.throw401Unauthorized();
        }
    }

    @Override
    @GET
    @Path(value="/user")
    @Produces(value={"text/plain"})
    public String getUsername() {
        try {
            HttpSession session = this.request.getSession(false);
            if (session == null) {
                return null;
            }
            return this.username(session);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public Topic getUsername(String username) {
        return this.dms.getTopic("dm4.accesscontrol.username", new SimpleValue(username));
    }

    @Override
    @GET
    @Path(value="/topic/{id}")
    public Permissions getTopicPermissions(@PathParam(value="id") long topicId) {
        return this.getPermissions((DeepaMehtaObject)this.dms.getTopic(topicId));
    }

    @Override
    @GET
    @Path(value="/association/{id}")
    public Permissions getAssociationPermissions(@PathParam(value="id") long assocId) {
        return this.getPermissions((DeepaMehtaObject)this.dms.getAssociation(assocId));
    }

    @Override
    public String getCreator(DeepaMehtaObject object) {
        return object.hasProperty(URI_CREATOR) ? (String)object.getProperty(URI_CREATOR) : null;
    }

    @Override
    public void setCreator(DeepaMehtaObject object, String username) {
        try {
            object.setProperty(URI_CREATOR, (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator of " + this.info(object) + " failed (username=" + username + ")", e);
        }
    }

    @Override
    public String getOwner(DeepaMehtaObject object) {
        return object.hasProperty(URI_OWNER) ? (String)object.getProperty(URI_OWNER) : null;
    }

    @Override
    public void setOwner(DeepaMehtaObject object, String username) {
        try {
            object.setProperty(URI_OWNER, (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the owner of " + this.info(object) + " failed (username=" + username + ")", e);
        }
    }

    @Override
    public AccessControlList getACL(DeepaMehtaObject object) {
        try {
            if (object.hasProperty(URI_ACL)) {
                return new AccessControlList(new JSONObject((String)object.getProperty(URI_ACL)));
            }
            return new AccessControlList(new ACLEntry[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching the ACL of " + this.info(object) + " failed", e);
        }
    }

    @Override
    public void setACL(DeepaMehtaObject object, AccessControlList acl) {
        try {
            object.setProperty(URI_ACL, (Object)acl.toJSON().toString(), false);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the ACL of " + this.info(object) + " failed", e);
        }
    }

    @Override
    @POST
    @Path(value="/user/{username}/workspace/{workspace_id}")
    @Transactional
    public void joinWorkspace(@PathParam(value="username") String username, @PathParam(value="workspace_id") long workspaceId) {
        this.joinWorkspace(this.getUsername(username), workspaceId);
    }

    @Override
    public void joinWorkspace(Topic username, long workspaceId) {
        try {
            this.wsService.assignToWorkspace((DeepaMehtaObject)username, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Joining user " + username + " to workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/creator/{username}/topics")
    public Collection<Topic> getTopicsByCreator(@PathParam(value="username") String username) {
        return this.dms.getTopicsByProperty(URI_CREATOR, (Object)username);
    }

    @Override
    @GET
    @Path(value="/owner/{username}/topics")
    public Collection<Topic> getTopicsByOwner(@PathParam(value="username") String username) {
        return this.dms.getTopicsByProperty(URI_OWNER, (Object)username);
    }

    @Override
    @GET
    @Path(value="/creator/{username}/assocs")
    public Collection<Association> getAssociationsByCreator(@PathParam(value="username") String username) {
        return this.dms.getAssociationsByProperty(URI_CREATOR, (Object)username);
    }

    @Override
    @GET
    @Path(value="/owner/{username}/assocs")
    public Collection<Association> getAssociationsByOwner(@PathParam(value="username") String username) {
        return this.dms.getAssociationsByProperty(URI_OWNER, (Object)username);
    }

    public void postInstall() {
        this.logger.info("Creating \"admin\" user account");
        Topic adminAccount = this.createUserAccount(new Credentials(DEFAULT_USERNAME, DEFAULT_PASSWORD));
        this.setupAccessControl((DeepaMehtaObject)adminAccount, DEFAULT_USER_ACCOUNT_ACL, DEFAULT_USERNAME);
    }

    public void init() {
        this.logger.info("Security settings:\ndm4.security.read_requires_login=" + READ_REQUIRES_LOGIN + "\ndm4.security.write_requires_login=" + WRITE_REQUIRES_LOGIN + "\ndm4.security.subnet_filter=\"" + SUBNET_FILTER + "\"");
    }

    public void allPluginsActive() {
        DeepaMehtaTransaction tx = this.dms.beginTx();
        try {
            Topic defaultUser = this.fetchDefaultUser();
            this.assignToDefaultWorkspace(defaultUser, "default user (\"admin\")");
            Topic defaultTopicmap = this.fetchDefaultTopicmap();
            if (defaultTopicmap != null) {
                this.assignToDefaultWorkspace(defaultTopicmap, "default topicmap (\"untitled\")");
                this.setupAccessControlForDefaultTopicmap(defaultTopicmap);
            }
            tx.success();
        }
        catch (Exception e) {
            this.logger.warning("ROLLBACK! (" + this + ")");
            throw new RuntimeException("Setting up " + this + " failed", e);
        }
        finally {
            tx.finish();
        }
    }

    public void postCreateTopic(Topic topic) {
        if (this.isUserAccount(topic)) {
            this.setupUserAccountAccessControl(topic);
        } else {
            this.setupDefaultAccessControl((DeepaMehtaObject)topic);
        }
        this.joinIfWorkspace(topic);
    }

    public void postCreateAssociation(Association assoc) {
        this.setupDefaultAccessControl((DeepaMehtaObject)assoc);
    }

    public void postUpdateTopic(Topic topic, TopicModel newModel, TopicModel oldModel) {
        if (topic.getTypeUri().equals("dm4.accesscontrol.user_account")) {
            String oldUsername;
            Topic usernameTopic = topic.getChildTopics().getTopic("dm4.accesscontrol.username");
            Topic passwordTopic = topic.getChildTopics().getTopic("dm4.accesscontrol.password");
            String newUsername = usernameTopic.getSimpleValue().toString();
            TopicModel oldUsernameTopic = oldModel.getChildTopicsModel().getTopic("dm4.accesscontrol.username", null);
            String string = oldUsername = oldUsernameTopic != null ? oldUsernameTopic.getSimpleValue().toString() : DEFAULT_PASSWORD;
            if (!newUsername.equals(oldUsername)) {
                if (!oldUsername.equals(DEFAULT_PASSWORD)) {
                    throw new RuntimeException("Changing a Username is not supported (tried \"" + oldUsername + "\" -> \"" + newUsername + "\")");
                }
                this.logger.info("### Username has changed from \"" + oldUsername + "\" -> \"" + newUsername + "\". Setting \"" + newUsername + "\" as the new owner of 3 topics:\n" + "    - User Account topic (ID " + topic.getId() + ")\n" + "    - Username topic (ID " + usernameTopic.getId() + ")\n" + "    - Password topic (ID " + passwordTopic.getId() + ")");
                this.setOwner((DeepaMehtaObject)topic, newUsername);
                this.setOwner((DeepaMehtaObject)usernameTopic, newUsername);
                this.setOwner((DeepaMehtaObject)passwordTopic, newUsername);
            }
        }
    }

    public void introduceTopicType(TopicType topicType) {
        this.setupDefaultAccessControl((Type)topicType);
    }

    public void introduceAssociationType(AssociationType assocType) {
        this.setupDefaultAccessControl((Type)assocType);
    }

    public void serviceRequestFilter(ContainerRequest containerRequest) {
        this.requestFilter(this.request);
    }

    public void resourceRequestFilter(HttpServletRequest servletRequest) {
        this.requestFilter(servletRequest);
    }

    public void preSendTopicType(TopicType topicType) {
        if (topicType.getUri().equals("dm4.core.meta_meta_type")) {
            this.enrichWithPermissions((Type)topicType, this.createPermissions(false, false));
            return;
        }
        this.enrichWithPermissions((Type)topicType, this.getPermissions((Type)topicType));
    }

    public void preSendAssociationType(AssociationType assocType) {
        this.enrichWithPermissions((Type)assocType, this.getPermissions((Type)assocType));
    }

    private Topic createUserAccount(Credentials cred) {
        return this.dms.createTopic(new TopicModel("dm4.accesscontrol.user_account", new ChildTopicsModel().put("dm4.accesscontrol.username", (Object)cred.username).put("dm4.accesscontrol.password", (Object)cred.password)));
    }

    private boolean isUserAccount(Topic topic) {
        String typeUri = topic.getTypeUri();
        return typeUri.equals("dm4.accesscontrol.user_account") || typeUri.equals("dm4.accesscontrol.username") || typeUri.equals("dm4.accesscontrol.password");
    }

    private Topic fetchDefaultUser() {
        return this.getUsernameOrThrow(DEFAULT_USERNAME);
    }

    private Topic getUsernameOrThrow(String username) {
        Topic usernameTopic = this.getUsername(username);
        if (usernameTopic == null) {
            throw new RuntimeException("User \"" + username + "\" does not exist");
        }
        return usernameTopic;
    }

    private void joinIfWorkspace(Topic topic) {
        String username;
        if (topic.getTypeUri().equals("dm4.workspaces.workspace") && (username = this.getUsername()) != null) {
            this.joinWorkspace(username, topic.getId());
        }
    }

    private void assignToDefaultWorkspace(Topic topic, String info) {
        String operation = "### Assigning the " + info + " to the default workspace (\"DeepaMehta\")";
        try {
            List workspaces = this.wsService.getAssignedWorkspaces((DeepaMehtaObject)topic);
            if (workspaces.size() != 0) {
                this.logger.info("### Assigning the " + info + " to a workspace ABORTED -- " + "already assigned (" + DeepaMehtaUtils.topicNames((Iterable)workspaces) + ")");
                return;
            }
            this.logger.info(operation);
            Topic defaultWorkspace = this.wsService.getDefaultWorkspace();
            this.wsService.assignToWorkspace((DeepaMehtaObject)topic, defaultWorkspace.getId());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    private void setupAccessControlForDefaultTopicmap(Topic defaultTopicmap) {
        String operation = "### Setup access control for the default topicmap (\"untitled\")";
        try {
            if (this.getCreator((DeepaMehtaObject)defaultTopicmap) != null) {
                this.logger.info(operation + " ABORTED -- already setup");
                return;
            }
            this.logger.info(operation);
            this.setupAccessControl((DeepaMehtaObject)defaultTopicmap, DEFAULT_INSTANCE_ACL, DEFAULT_USERNAME);
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    private Topic fetchDefaultTopicmap() {
        return this.dms.getTopic("uri", new SimpleValue("dm4.topicmaps.default_topicmap"));
    }

    private void requestFilter(HttpServletRequest request) {
        this.logger.fine("##### " + request.getMethod() + " " + request.getRequestURL() + "\n      ##### \"Authorization\"=\"" + request.getHeader("Authorization") + "\"" + "\n      ##### " + this.info(request.getSession(false)));
        this.checkRequestOrigin(request);
        this.checkAuthorization(request);
    }

    private void checkRequestOrigin(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        boolean allowed = JavaUtils.isInRange((String)remoteAddr, (String)SUBNET_FILTER);
        this.logger.fine("Remote address=\"" + remoteAddr + "\", dm4.security.subnet_filter=\"" + SUBNET_FILTER + "\" => " + (allowed ? "ALLOWED" : "FORBIDDEN"));
        if (!allowed) {
            this.throw403Forbidden();
        }
    }

    private void checkAuthorization(HttpServletRequest request) {
        boolean authorized;
        if (request.getSession(false) != null) {
            authorized = true;
        } else {
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null) {
                authorized = this.tryLogin(new Credentials(authHeader), request);
            } else {
                boolean bl = authorized = !this.isLoginRequired(request);
            }
        }
        if (!authorized) {
            this.throw401Unauthorized();
        }
    }

    private boolean isLoginRequired(HttpServletRequest request) {
        return request.getMethod().equals("GET") ? READ_REQUIRES_LOGIN : WRITE_REQUIRES_LOGIN;
    }

    private boolean tryLogin(Credentials cred, HttpServletRequest request) {
        String username = cred.username;
        if (this.checkCredentials(cred)) {
            this.logger.info("##### Logging in as \"" + username + "\" => SUCCESSFUL!");
            this._login(username, request);
            return true;
        }
        this.logger.info("##### Logging in as \"" + username + "\" => FAILED!");
        return false;
    }

    private boolean checkCredentials(Credentials cred) {
        Topic username = this.getUsername(cred.username);
        if (username == null) {
            return false;
        }
        return this.matches(username, cred.password);
    }

    private void _login(String username, HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setAttribute("username", (Object)username);
        this.logger.info("##### Creating new " + this.info(session));
        this.dms.fireEvent(POST_LOGIN_USER, new Object[]{username});
    }

    private void _logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String username = this.username(session);
        this.logger.info("##### Logging out from " + this.info(session));
        session.invalidate();
        this.dms.fireEvent(POST_LOGOUT_USER, new Object[]{username});
    }

    private boolean matches(Topic username, String password) {
        return this.password(this.fetchUserAccount(username)).equals(password);
    }

    private Topic fetchUserAccount(Topic username) {
        RelatedTopic userAccount = username.getRelatedTopic("dm4.core.composition", "dm4.core.child", "dm4.core.parent", "dm4.accesscontrol.user_account");
        if (userAccount == null) {
            throw new RuntimeException("Data inconsistency: there is no User Account topic for username \"" + username.getSimpleValue() + "\" (username=" + username + ")");
        }
        return userAccount;
    }

    private String username(HttpSession session) {
        String username = (String)session.getAttribute("username");
        if (username == null) {
            throw new RuntimeException("Session data inconsistency: \"username\" attribute is missing");
        }
        return username;
    }

    private String password(Topic userAccount) {
        return userAccount.getChildTopics().getString("dm4.accesscontrol.password");
    }

    private void throw401Unauthorized() {
        String authScheme = READ_REQUIRES_LOGIN ? "Basic" : "xBasic";
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)(authScheme + " realm=" + AUTHENTICATION_REALM)).header("Content-Type", (Object)"text/html").entity((Object)"You're not authorized. Sorry.").build());
    }

    private void throw403Forbidden() {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"text/html").entity((Object)"Access is forbidden. Sorry.").build());
    }

    private void setupDefaultAccessControl(DeepaMehtaObject object) {
        this.setupAccessControl(object, DEFAULT_INSTANCE_ACL);
    }

    private void setupDefaultAccessControl(Type type) {
        try {
            String username = this.getUsername();
            if (username == null) {
                username = DEFAULT_USERNAME;
                this.setupViewConfigAccessControl(type.getViewConfig());
            }
            this.setupAccessControl((DeepaMehtaObject)type, DEFAULT_TYPE_ACL, username);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up access control for " + this.info((DeepaMehtaObject)type) + " failed (" + type + ")", e);
        }
    }

    private void setupUserAccountAccessControl(Topic topic) {
        this.setupAccessControl((DeepaMehtaObject)topic, DEFAULT_USER_ACCOUNT_ACL);
    }

    private void setupViewConfigAccessControl(ViewConfiguration viewConfig) {
        for (Topic configTopic : viewConfig.getConfigTopics()) {
            this.setupAccessControl((DeepaMehtaObject)configTopic, DEFAULT_INSTANCE_ACL, DEFAULT_USERNAME);
        }
    }

    private void setupAccessControl(DeepaMehtaObject object, AccessControlList acl) {
        try {
            String username = this.getUsername();
            if (username == null) {
                this.logger.fine("Setting up access control for " + this.info(object) + " ABORTED -- no user is logged in");
                return;
            }
            this.setupAccessControl(object, acl, username);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up access control for " + this.info(object) + " failed (" + object + ")", e);
        }
    }

    private void setupAccessControl(DeepaMehtaObject object, AccessControlList acl, String username) {
        this.setCreator(object, username);
        this.setOwner(object, username);
        this.setACL(object, acl);
    }

    private Permissions getPermissions(DeepaMehtaObject object) {
        return this.createPermissions(this.hasPermission(this.getUsername(), Operation.WRITE, object));
    }

    private Permissions getPermissions(Type type) {
        String username = this.getUsername();
        return this.createPermissions(this.hasPermission(username, Operation.WRITE, (DeepaMehtaObject)type), this.hasPermission(username, Operation.CREATE, (DeepaMehtaObject)type));
    }

    private boolean hasPermission(String username, Operation operation, DeepaMehtaObject object) {
        try {
            UserRole[] userRoles;
            this.logger.fine("Determining permission for " + this.userInfo(username) + " to " + (Object)((Object)operation) + " " + this.info(object));
            for (UserRole userRole : userRoles = this.getACL(object).getUserRoles(operation)) {
                this.logger.fine("There is an ACL entry for user role " + (Object)((Object)userRole));
                if (!this.userOccupiesRole(username, userRole, object)) continue;
                this.logger.fine("=> ALLOWED");
                return true;
            }
            this.logger.fine("=> DENIED");
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Determining permission for " + this.info(object) + " failed (" + this.userInfo(username) + ", operation=" + (Object)((Object)operation) + ")", e);
        }
    }

    private boolean userOccupiesRole(String username, UserRole userRole, DeepaMehtaObject object) {
        switch (userRole) {
            case EVERYONE: {
                return true;
            }
            case USER: {
                return username != null;
            }
            case MEMBER: {
                return username != null && this.userIsMember(username, object);
            }
            case OWNER: {
                return username != null && this.userIsOwner(username, object);
            }
            case CREATOR: {
                return username != null && this.userIsCreator(username, object);
            }
        }
        throw new RuntimeException((Object)((Object)userRole) + " is an unsupported user role");
    }

    private boolean userIsMember(String username, DeepaMehtaObject object) {
        Topic usernameTopic = this.getUsernameOrThrow(username);
        List workspaces = this.wsService.getAssignedWorkspaces(object);
        this.logger.fine(this.info(object) + " is assigned to " + workspaces.size() + " workspaces");
        for (RelatedTopic workspace : workspaces) {
            if (this.wsService.isAssignedToWorkspace(usernameTopic, workspace.getId())) {
                this.logger.fine(this.userInfo(username) + " IS member of workspace " + workspace);
                return true;
            }
            this.logger.fine(this.userInfo(username) + " is NOT member of workspace " + workspace);
        }
        return false;
    }

    private boolean userIsOwner(String username, DeepaMehtaObject object) {
        String owner = this.getOwner(object);
        this.logger.fine("The owner is " + this.userInfo(owner));
        return owner != null && owner.equals(username);
    }

    private boolean userIsCreator(String username, DeepaMehtaObject object) {
        String creator = this.getCreator(object);
        this.logger.fine("The creator is " + this.userInfo(creator));
        return creator != null && creator.equals(username);
    }

    private void enrichWithPermissions(Type type, Permissions permissions) {
        ChildTopicsModel typePermissions = this.permissions((DeepaMehtaObject)type);
        typePermissions.put(Operation.WRITE.uri, permissions.get(Operation.WRITE.uri));
        typePermissions.put(Operation.CREATE.uri, permissions.get(Operation.CREATE.uri));
    }

    private ChildTopicsModel permissions(DeepaMehtaObject object) {
        ChildTopicsModel permissions;
        TopicModel permissionsTopic = object.getChildTopics().getModel().getTopic("dm4.accesscontrol.permissions", null);
        if (permissionsTopic != null) {
            permissions = permissionsTopic.getChildTopicsModel();
        } else {
            permissions = new ChildTopicsModel();
            object.getChildTopics().getModel().put("dm4.accesscontrol.permissions", permissions);
        }
        return permissions;
    }

    private Permissions createPermissions(boolean write) {
        return new Permissions().add(Operation.WRITE, write);
    }

    private Permissions createPermissions(boolean write, boolean create) {
        return this.createPermissions(write).add(Operation.CREATE, create);
    }

    private String info(DeepaMehtaObject object) {
        if (object instanceof TopicType) {
            return "topic type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof AssociationType) {
            return "association type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Association) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }

    private String info(HttpSession session) {
        return "session" + (session != null ? " " + session.getId() + " (username=" + this.username(session) + ")" : ": null");
    }

    private String info(HttpServletRequest request) {
        StringBuilder info = new StringBuilder();
        info.append("    " + request.getMethod() + " " + request.getRequestURI() + "\n");
        Enumeration e1 = request.getHeaderNames();
        while (e1.hasMoreElements()) {
            String name = (String)e1.nextElement();
            info.append("\n    " + name + ":");
            Enumeration e2 = request.getHeaders(name);
            while (e2.hasMoreElements()) {
                String header = (String)e2.nextElement();
                info.append(" " + header);
            }
        }
        return info.toString();
    }
}

