/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.sector.encoder;

import de.datexis.encoder.Encoder;
import de.datexis.encoder.impl.BagOfWordsEncoder;
import de.datexis.model.Annotation;
import de.datexis.model.Document;
import de.datexis.model.Sentence;
import de.datexis.model.tag.Tag;
import de.datexis.sector.model.SectionAnnotation;
import java.io.IOException;
import java.util.Iterator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadingTag
implements Tag {
    protected static final Logger log = LoggerFactory.getLogger(HeadingTag.class);
    protected final String label;
    protected byte[] vector = null;
    protected final long length;
    protected double confidence = 0.0;

    protected HeadingTag(String label, INDArray vector) {
        this.label = label;
        this.length = vector == null ? 0L : vector.length();
        try {
            if (vector != null) {
                this.vector = Nd4j.toByteArray((INDArray)vector);
            }
        }
        catch (IOException ex) {
            log.error("IOError in HeadingTag: {}", (Object)ex.toString());
        }
    }

    public String getTag() {
        return this.label;
    }

    public String getTag(int index) {
        throw new UnsupportedOperationException("Not possible without encoder.");
    }

    public int getVectorSize() {
        return (int)this.length;
    }

    public INDArray getVector() {
        return Nd4j.fromByteArray((byte[])this.vector);
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public static class Factory {
        protected final BagOfWordsEncoder encoder;

        public Factory(BagOfWordsEncoder encoder) {
            this.encoder = encoder;
        }

        public HeadingTag create(String heading) {
            return new HeadingTag(heading, this.encoder.encode(heading));
        }

        public HeadingTag create(INDArray prediction) {
            return new HeadingTag(this.encoder.getNearestNeighbour(prediction), prediction);
        }

        public void attachFromSectionAnnotations(Document doc, Annotation.Source source) {
            this.attachFromSectionAnnotations(doc, source, true);
        }

        public void attachFromSectionAnnotations(Document doc, Annotation.Source source, boolean attachVectors) {
            Iterator sections = doc.streamAnnotations(source, SectionAnnotation.class).sorted().iterator();
            if (doc.countSentences() <= 0) {
                return;
            }
            if (!sections.hasNext()) {
                throw new IllegalArgumentException("Document has no sections");
            }
            SectionAnnotation ann = (SectionAnnotation)((Object)sections.next());
            String title = ann.getSectionHeading();
            INDArray vec = attachVectors ? this.encoder.encode(title) : null;
            HeadingTag tag = new HeadingTag(title, vec);
            for (Sentence s : doc.getSentences()) {
                while (s.getBegin() >= ann.getEnd()) {
                    if (sections.hasNext()) {
                        ann = (SectionAnnotation)((Object)sections.next());
                        title = ann.getSectionHeading();
                        vec = attachVectors ? this.encoder.encode(title) : null;
                        tag = new HeadingTag(title, vec);
                        continue;
                    }
                    log.error("Found Document with missing SectionAnnotations for Sentence position {}", (Object)s.getBegin());
                }
                s.putTag(source, (Tag)tag);
            }
            doc.setTagAvailable(source, HeadingTag.class, true);
        }

        public void attachFromSentenceVectors(Document doc, Class<? extends Encoder> encoder, Annotation.Source source) {
            for (Sentence s : doc.getSentences()) {
                s.putTag(source, (Tag)this.create(s.getVector(encoder)));
            }
            doc.setTagAvailable(source, HeadingTag.class, true);
        }
    }
}

