/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.parvec.encoder;

import de.datexis.model.Annotation;
import de.datexis.model.Dataset;
import de.datexis.model.Document;
import de.datexis.sector.model.SectionAnnotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;
import org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParVecIterator
implements LabelAwareSentenceIterator {
    protected static final Logger log = LoggerFactory.getLogger(ParVecIterator.class);
    protected List<Document> documents;
    protected Iterator<Document> docIt;
    protected Document currentDoc;
    protected List<SectionAnnotation> sections;
    protected Iterator<SectionAnnotation> annIt;
    protected SectionAnnotation currentSection;
    protected int batchSize;
    protected boolean randomize;

    public ParVecIterator(Dataset data, boolean randomize) {
        this(data.getDocuments(), randomize);
    }

    public ParVecIterator(Collection<Document> docs, boolean randomize) {
        this.documents = new ArrayList<Document>(docs);
        this.randomize = randomize;
    }

    public void reset() {
        this.currentSection = null;
        this.annIt = null;
        this.sections = new ArrayList<SectionAnnotation>(64);
        this.currentDoc = null;
        if (this.randomize) {
            Collections.shuffle(this.documents, new Random(System.nanoTime()));
        }
        this.docIt = this.documents.iterator();
    }

    public boolean hasNext() {
        if (this.hasNextSection()) {
            return true;
        }
        if (this.hasNextDocument()) {
            this.nextDocument();
            return this.hasNext();
        }
        return false;
    }

    protected boolean hasNextSection() {
        return this.annIt != null && this.annIt.hasNext();
    }

    protected boolean hasNextDocument() {
        return this.docIt != null && this.docIt.hasNext();
    }

    public void nextDocument() {
        this.currentDoc = this.docIt.next();
        this.sections = this.currentDoc.streamAnnotations(Annotation.Source.GOLD, SectionAnnotation.class).collect(Collectors.toList());
        this.annIt = this.sections.iterator();
    }

    public String nextSentence() {
        this.currentSection = this.annIt.next();
        String text = this.currentDoc.streamTokensInRange(this.currentSection.getBegin(), this.currentSection.getEnd(), true).map(t -> t.getText().trim().replaceAll("\n", "*NL*").replaceAll("\t", "*t*")).collect(Collectors.joining(" "));
        return text;
    }

    public String currentLabel() {
        return this.currentSection.getSectionLabel();
    }

    public List<String> currentLabels() {
        return Arrays.asList(this.currentSection.getSectionLabel());
    }

    public void finish() {
        this.currentSection = null;
        this.annIt = null;
        this.sections.clear();
        this.currentDoc = null;
        this.docIt = null;
        this.documents.clear();
    }

    public SentencePreProcessor getPreProcessor() {
        return null;
    }

    public void setPreProcessor(SentencePreProcessor preProcessor) {
    }
}

