/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.sector.eval;

import de.datexis.annotator.AnnotatorEvaluation;
import de.datexis.encoder.LookupCacheEncoder;
import de.datexis.model.Annotation;
import de.datexis.model.Dataset;
import de.datexis.model.Document;
import de.datexis.model.Sentence;
import de.datexis.sector.encoder.ClassTag;
import de.datexis.sector.encoder.HeadingEncoder;
import de.datexis.sector.encoder.HeadingTag;
import de.datexis.sector.eval.ClassificationEvaluation;
import de.datexis.sector.eval.SegmentationEvaluation;
import de.datexis.sector.model.SectionAnnotation;
import java.util.Collection;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectorEvaluation
extends AnnotatorEvaluation {
    protected static final Logger log = LoggerFactory.getLogger(SectorEvaluation.class);
    protected boolean enableSentenceEval = true;
    protected boolean enableSegmentEval = true;
    protected boolean enableSegmentationEval = true;
    protected int countSections;
    protected int countPredictions;
    protected ClassificationEvaluation sentenceClassEval;
    protected ClassificationEvaluation segmentClassEval;
    protected SegmentationEvaluation segmentationEval;
    protected Class targetEncoderClass;

    public SectorEvaluation(String experimentName, Annotation.Source expected, Annotation.Source predicted, LookupCacheEncoder targetEncoder) {
        super(experimentName, expected, predicted);
        this.sentenceClassEval = new ClassificationEvaluation(experimentName, this.expectedSource, this.predictedSource, targetEncoder, 3);
        this.segmentClassEval = new ClassificationEvaluation(experimentName, this.expectedSource, this.predictedSource, targetEncoder, 3);
        this.segmentationEval = new SegmentationEvaluation(experimentName);
        this.targetEncoderClass = targetEncoder.getClass();
    }

    public SectorEvaluation(String experimentName, Annotation.Source expected, Annotation.Source predicted) {
        super(experimentName, expected, predicted);
        this.sentenceClassEval = null;
        this.segmentClassEval = null;
        this.segmentationEval = new SegmentationEvaluation(experimentName);
    }

    public SectorEvaluation withSentenceClassEvaluation(boolean enable) {
        this.enableSentenceEval = enable;
        return this;
    }

    public SectorEvaluation withSegmentationEvaluation(boolean enable) {
        this.enableSegmentationEval = enable;
        return this;
    }

    public SectorEvaluation withSegmentClassEvaluation(boolean enable) {
        this.enableSegmentEval = enable;
        return this;
    }

    public SectorEvaluation withRecalculateK(boolean enabled) {
        this.segmentationEval.withRecalculateK(enabled);
        return this;
    }

    public SectorEvaluation withMergeEnabled(boolean enabled) {
        this.segmentationEval.withMergeEnabled(enabled);
        return this;
    }

    public void calculateScores(Collection<Document> docs) {
        log.info("Evaluating SECTOR...");
        this.countSections = 0;
        this.countPredictions = 0;
        this.countExamples = 0;
        this.countDocs = 0;
        if (this.enableSentenceEval && this.sentenceClassEval != null) {
            log.info("calculating sentence scores from tags...");
            if (this.targetEncoderClass == HeadingEncoder.class) {
                this.sentenceClassEval.calculateScoresFromTags(docs, Sentence.class, HeadingTag.class);
            } else {
                this.sentenceClassEval.calculateScoresFromTags(docs, Sentence.class, ClassTag.class);
            }
        }
        if (this.enableSegmentationEval && this.segmentationEval != null) {
            log.info("calculating segmentation scores from annotations...");
            this.segmentationEval.calculateScoresFromAnnotations(docs, SectionAnnotation.class);
        }
        if (this.enableSegmentEval && this.segmentClassEval != null) {
            log.info("calculating segment scores from annotations...");
            this.segmentClassEval.calculateScoresFromAnnotations(docs, SectionAnnotation.class, true);
        }
        log.info("done.");
        for (Document doc : docs) {
            Collection expected = doc.getAnnotations(this.expectedSource, SectionAnnotation.class);
            Collection predicted = doc.getAnnotations(this.predictedSource, SectionAnnotation.class);
            ++this.countDocs;
            this.countExamples += doc.countSentences();
            this.countSections += expected.size();
            this.countPredictions += predicted.size();
        }
    }

    public double getScore() {
        if (this.enableSegmentEval && this.segmentClassEval != null) {
            return this.segmentClassEval.getScore();
        }
        if (this.enableSentenceEval && this.sentenceClassEval != null) {
            return this.sentenceClassEval.getScore();
        }
        return 0.0;
    }

    public static String printDatasetStats(Dataset dataset) {
        StringBuilder line = new StringBuilder();
        line.append("DATASET:\t").append(dataset.getName()).append("\n");
        line.append("#Docs\t#Sents\t#Tokens\t#Anns\n");
        line.append(String.format(Locale.ROOT, "%,d", dataset.countDocuments())).append("\t");
        line.append(String.format(Locale.ROOT, "%,d", dataset.countSentences())).append("\t");
        line.append(String.format(Locale.ROOT, "%,d", dataset.countTokens())).append("\t");
        line.append(String.format(Locale.ROOT, "%,d", dataset.countAnnotations(Annotation.Source.GOLD))).append("\t");
        line.append("------------------------------------------------------------------------------\n");
        System.out.println(line.toString());
        return line.toString();
    }

    public String printEvaluationStats() {
        if (this.sentenceClassEval == null) {
            this.enableSentenceEval = false;
        }
        if (this.segmentationEval == null) {
            this.enableSegmentationEval = false;
        }
        if (this.segmentClassEval == null) {
            this.enableSegmentEval = false;
        }
        StringBuilder line = new StringBuilder();
        line.append("SECTOR EVALUATION [micro-avg] ").append(this.targetEncoderClass.getSimpleName()).append("\n").append("|statistics ---\t");
        if (this.enableSentenceEval) {
            line.append("|sentence classification -------------------------------------\t");
        }
        if (this.enableSegmentationEval) {
            line.append("|segmentation --------------------------------\t");
        }
        if (this.enableSegmentEval) {
            line.append("|segment classification ----------------------------");
        }
        line.append("\n").append("||docs|\t|sents|\t");
        if (this.enableSentenceEval) {
            line.append("| A@1\t A@3\t P@1\t P@3\t R@1\t R@3\t MAP\t");
        }
        if (this.enableSegmentationEval) {
            line.append("| |exp|\t |relv|\t |pred|\t |retr|\t Pk\t WD\t");
        }
        if (this.enableSegmentEval) {
            line.append("| A@1\t A@3\t P@1\t P@3\t R@1\t R@3\t MAP");
        }
        line.append("\n");
        line.append(SectorEvaluation.fInt((double)this.countDocuments())).append("\t");
        line.append(SectorEvaluation.fInt((double)this.countExamples())).append("\t");
        if (this.enableSentenceEval) {
            line.append(SectorEvaluation.fDbl((double)this.sentenceClassEval.getAccuracy())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.sentenceClassEval.getAccuracyK())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.sentenceClassEval.getPrecision1())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.sentenceClassEval.getPrecisionK())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.sentenceClassEval.getRecall1())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.sentenceClassEval.getRecallK())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.sentenceClassEval.getMAP())).append("\t");
        }
        if (this.enableSegmentationEval) {
            line.append(SectorEvaluation.fInt((double)this.countSections())).append("\t");
            line.append(SectorEvaluation.fInt((double)this.segmentationEval.getCountExpected())).append("\t");
            line.append(SectorEvaluation.fInt((double)this.countPredictions())).append("\t");
            line.append(SectorEvaluation.fInt((double)this.segmentationEval.getCountPredicted())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.segmentationEval.getPk())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.segmentationEval.getWD())).append("\t");
        }
        if (this.enableSegmentEval) {
            line.append(SectorEvaluation.fDbl((double)this.segmentClassEval.getAccuracy())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.segmentClassEval.getAccuracyK())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.segmentClassEval.getPrecision1())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.segmentClassEval.getPrecisionK())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.segmentClassEval.getRecall1())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.segmentClassEval.getRecallK())).append("\t");
            line.append(SectorEvaluation.fDbl((double)this.segmentClassEval.getMAP())).append("\t");
        }
        line.append("\n");
        System.out.println(line.toString());
        return line.toString();
    }

    public String printSingleClassStats() {
        if (this.enableSegmentEval && this.segmentClassEval.numClasses < 50) {
            return SectorEvaluation.printSingleClassStats(this.segmentClassEval);
        }
        if (this.enableSentenceEval && this.sentenceClassEval.numClasses < 50) {
            return SectorEvaluation.printSingleClassStats(this.sentenceClassEval);
        }
        return "Too many classes for single-class stats";
    }

    public static String printSingleClassStats(ClassificationEvaluation eval) {
        StringBuilder line = new StringBuilder();
        line.append("SINGLE-LABEL CLASSIFICATION [performance per class]\n").append("No\tClass\t#Examples\tTP\tFP\tAcc\tPrec\tRec\tF1\n");
        for (int c = 0; c < eval.numClasses; ++c) {
            line.append(c).append("\t");
            line.append(eval.eval.getClassLabel(Integer.valueOf(c))).append("\t");
            line.append(SectorEvaluation.fInt((double)eval.eval.getConfusionMatrix().getActualTotal((Comparable)Integer.valueOf(c)))).append("\t");
            line.append(SectorEvaluation.fInt((double)eval.eval.getTruePositives().getCount((Object)c))).append("\t");
            line.append(SectorEvaluation.fInt((double)eval.eval.getFalsePositives().getCount((Object)c))).append("\t");
            line.append(SectorEvaluation.fDbl((double)eval.getAccuracy(c))).append("\t");
            line.append(SectorEvaluation.fDbl((double)eval.getPrecision(c))).append("\t");
            line.append(SectorEvaluation.fDbl((double)eval.getRecall(c))).append("\t");
            line.append(SectorEvaluation.fDbl((double)eval.getF1(c))).append("\t");
            line.append("\n");
        }
        System.out.println(line.toString());
        return line.toString();
    }

    private double countSections() {
        return this.countSections;
    }

    private double countPredictions() {
        return this.countPredictions;
    }
}

