/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.sector.reader;

import com.fasterxml.jackson.databind.MappingIterator;
import de.datexis.common.ObjectSerializer;
import de.datexis.common.Resource;
import de.datexis.model.Annotation;
import de.datexis.model.Dataset;
import de.datexis.model.Document;
import de.datexis.reader.DatasetReader;
import de.datexis.sector.model.WikiDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiSectionReader
implements DatasetReader {
    protected static final Logger log = LoggerFactory.getLogger(WikiSectionReader.class);

    public Dataset read(Resource path) throws IOException {
        return WikiSectionReader.readDatasetFromJSON(path);
    }

    public static Dataset readDatasetFromJSON(Resource path) throws IOException {
        log.info("Reading Wiki Articles from {}", (Object)path.toString());
        Dataset result = new Dataset(path.getFileName().replace(".json", ""));
        Iterator it = ObjectSerializer.readJSONDocumentIterable((Resource)path);
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            for (Annotation ann : doc.getAnnotations()) {
                ann.setSource(Annotation.Source.GOLD);
                ann.setConfidence(1.0);
            }
            if (!doc.isEmpty()) {
                result.addDocument(doc);
                continue;
            }
            log.warn("read empty document {}", (Object)doc.getId());
        }
        return result;
    }

    public static List<WikiDocument> readWikiDocumentsFromJSON(Resource path) throws IOException {
        log.info("Reading Wiki Articles from {}", (Object)path.toString());
        ArrayList<WikiDocument> result = new ArrayList<WikiDocument>();
        MappingIterator it = ObjectSerializer.getObjectMapper().readerFor(WikiDocument.class).readValues(path.getInputStream());
        while (it.hasNext()) {
            WikiDocument doc = (WikiDocument)((Object)it.next());
            for (Annotation ann : doc.getAnnotations()) {
                ann.setSource(Annotation.Source.GOLD);
            }
            result.add(doc);
        }
        return result;
    }
}

