/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.sector.tagger;

import de.datexis.model.Dataset;
import de.datexis.model.Document;
import de.datexis.tagger.AbstractMultiDataSetIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.nd4j.linalg.dataset.api.MultiDataSet;

public abstract class DocumentSentenceIterator
extends AbstractMultiDataSetIterator {
    public DocumentSentenceIterator(AbstractMultiDataSetIterator.Stage stage, Dataset dataset, int batchSize, boolean randomize) {
        this(stage, dataset.getDocuments(), batchSize, randomize);
    }

    public DocumentSentenceIterator(AbstractMultiDataSetIterator.Stage stage, Collection<Document> docs, int batchSize, boolean randomize) {
        this(stage, docs, -1, -1, batchSize, randomize);
    }

    public DocumentSentenceIterator(AbstractMultiDataSetIterator.Stage stage, Collection<Document> docs, int numExamples, int maxTimeSeriesLength, int batchSize, boolean randomize) {
        super(stage, docs, numExamples, maxTimeSeriesLength, batchSize, randomize);
    }

    public void reset() {
        this.cursor = 0;
        if (this.randomize) {
            Collections.shuffle(this.documents, new Random(System.nanoTime()));
        }
        this.docIt = this.documents.iterator();
        this.startTime = System.currentTimeMillis();
    }

    protected boolean hasNextDocument() {
        return this.docIt != null && this.docIt.hasNext();
    }

    public boolean hasNext() {
        return this.hasNextDocument() && !this.reachedEnd();
    }

    protected Document nextDocument() {
        ++this.cursor;
        return (Document)this.docIt.next();
    }

    protected DocumentBatch nextBatch(int num) {
        ArrayList<Document> examples = new ArrayList<Document>(num);
        int exampleSize = 1;
        for (int batchNum = 0; batchNum < num; ++batchNum) {
            Document example = this.hasNext() ? this.nextDocument() : new Document();
            examples.add(example);
            exampleSize = this.maxTimeSeriesLength > 0 ? Math.min(Math.max(exampleSize, example.countSentences()), this.maxTimeSeriesLength) : Math.max(exampleSize, example.countSentences());
        }
        return new DocumentBatch(num, examples, exampleSize, null);
    }

    public MultiDataSet next(int num) {
        DocumentBatch batch = this.nextDocumentBatch(num);
        return batch.dataset;
    }

    public DocumentBatch nextDocumentBatch() {
        return this.nextDocumentBatch(this.batchSize);
    }

    public DocumentBatch nextDocumentBatch(int num) {
        DocumentBatch batch = this.nextBatch(num);
        batch.dataset = this.generateDataSet(batch);
        this.reportProgress(batch.maxDocLength);
        return batch;
    }

    public abstract MultiDataSet generateDataSet(DocumentBatch var1);

    public class DocumentBatch {
        public List<Document> docs;
        public MultiDataSet dataset;
        public int size;
        public int maxDocLength;

        public DocumentBatch(int batchSize, List<Document> docs, int maxDocLength, MultiDataSet dataset) {
            this.size = batchSize;
            this.docs = docs;
            this.dataset = dataset;
            this.maxDocLength = maxDocLength;
        }
    }
}

