/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.sector.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.datexis.model.Annotation;
import de.datexis.model.Document;
import de.datexis.model.Sentence;
import de.datexis.model.impl.PassageAnnotation;
import de.datexis.model.tag.BIO2Tag;
import de.datexis.model.tag.TFTag;
import de.datexis.model.tag.Tag;
import de.datexis.sector.encoder.ClassTag;
import java.util.stream.Collectors;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"class", "source", "begin", "length", "sectionHeading", "sectionLabel"})
@JsonIgnoreProperties(value={"confidence", "text"})
public class SectionAnnotation
extends PassageAnnotation {
    protected static final Logger log = LoggerFactory.getLogger(SectionAnnotation.class);
    protected String type;
    protected String sectionHeading;

    protected SectionAnnotation() {
    }

    public SectionAnnotation(Annotation.Source source) {
        super(source);
    }

    public SectionAnnotation(Annotation.Source source, String type, String sectionHeading) {
        super(source);
        this.type = type;
        this.sectionHeading = sectionHeading;
    }

    public String getSectionLabel() {
        return this.label;
    }

    public void setSectionLabel(String label) {
        this.label = label;
    }

    public String getSectionHeading() {
        return this.sectionHeading;
    }

    public void setSectionHeading(String sectionHeading) {
        this.sectionHeading = sectionHeading;
    }

    @JsonIgnore
    public String getSectionLabelOrHeading() {
        if (this.label != null && !this.label.isEmpty()) {
            return this.label;
        }
        if (this.sectionHeading != null && !this.sectionHeading.isEmpty()) {
            return this.sectionHeading;
        }
        return "";
    }

    public String getAnnotation(Field field) {
        if (field.equals((Object)Field.HEADING)) {
            return this.sectionHeading;
        }
        return this.label;
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    public boolean matches(SectionAnnotation other) {
        if (!this.getSectionLabel().equals(other.getSectionLabel())) {
            return false;
        }
        int p1 = this.getBegin();
        int p2 = other.getBegin();
        int e1 = p1 + this.getLength() - 1;
        int e2 = p2 + other.getLength() - 1;
        return p1 <= p2 && p2 <= e1 || p1 <= e2 && e2 <= e1 || p2 <= p1 && p1 <= e2 || p2 <= e1 && e1 <= e2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SectionAnnotation other = (SectionAnnotation)((Object)obj);
        if (this.begin != other.getBegin()) {
            return false;
        }
        if (this.end != other.getEnd()) {
            return false;
        }
        return !(this.label == null ? other.getSectionLabel() != null : !this.label.equals(other.getSectionLabel()));
    }

    @Deprecated
    public static void createClassTagsFromAnnotations(Document doc, Annotation.Source source) {
        boolean flip = true;
        for (SectionAnnotation ann : doc.getAnnotations(source, SectionAnnotation.class)) {
            boolean begin = true;
            for (Sentence s : doc.streamSentencesInRange(ann.getBegin(), ann.getEnd(), false).collect(Collectors.toList())) {
                s.putTag(source, (Tag)new ClassTag(ann.getSectionLabel(), Nd4j.create((int)0)));
                s.putTag(source, (Tag)(flip ? TFTag.T() : TFTag.F()));
                s.putTag(source, (Tag)(begin ? BIO2Tag.B() : BIO2Tag.I()));
                begin = false;
            }
            flip = !flip;
        }
    }

    public static enum Field {
        HEADING,
        LABEL;

    }
}

