/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.sector.exec;

import de.datexis.annotator.AnnotatorFactory;
import de.datexis.common.CommandLineParser;
import de.datexis.common.Resource;
import de.datexis.model.Dataset;
import de.datexis.sector.SectorAnnotator;
import de.datexis.sector.reader.WikiSectionReader;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateSectorAnnotator {
    protected static final Logger log = LoggerFactory.getLogger(EvaluateSectorAnnotator.class);

    public static void main(String[] args) throws IOException {
        ExecParams params = new ExecParams();
        CommandLineParser parser = new CommandLineParser((CommandLineParser.Options)params);
        try {
            parser.parse(args);
            new EvaluateSectorAnnotator().evaluate(params);
            System.exit(0);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("texoo-evaluate-sector", "TeXoo: evaluate SectorAnnotator on WikiSection dataset", params.setUpCliOptions(), "", true);
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void evaluate(ExecParams params) throws IOException {
        Resource testFile = Resource.fromDirectory((String)params.testFile);
        Resource modelPath = Resource.fromDirectory((String)params.modelPath);
        Resource embeddingsPath = params.embeddingsPath != null ? Resource.fromDirectory((String)params.embeddingsPath) : null;
        SectorAnnotator sector = (SectorAnnotator)(params.embeddingsPath != null ? AnnotatorFactory.loadAnnotator((Resource)modelPath, (Resource[])new Resource[]{embeddingsPath}) : AnnotatorFactory.loadAnnotator((Resource)modelPath, (Resource[])new Resource[0]));
        Dataset test = WikiSectionReader.readDatasetFromJSON(testFile);
        sector.annotate(test.getDocuments(), SectorAnnotator.SegmentationMethod.BEMD);
        sector.evaluateModel(test, false, true, true);
    }

    protected static class ExecParams
    implements CommandLineParser.Options {
        protected String modelPath = null;
        protected String testFile = null;
        protected String embeddingsPath = null;

        protected ExecParams() {
        }

        public void setParams(CommandLine parse) {
            this.modelPath = parse.getOptionValue("m");
            this.testFile = parse.getOptionValue("t");
            this.embeddingsPath = parse.getOptionValue("e");
        }

        public Options setUpCliOptions() {
            Options op = new Options();
            op.addRequiredOption("m", "model", true, "path to the pre-trained model");
            op.addRequiredOption("t", "test", true, "file name of WikiSection test dataset (will test after training if given)");
            op.addOption("e", "embedding", true, "search path to word embedding models (if not provided by the model itself)");
            return op;
        }
    }
}

