/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.sector.encoder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.datexis.encoder.Encoder;
import de.datexis.encoder.LookupCacheEncoder;
import de.datexis.model.Annotation;
import de.datexis.model.Document;
import de.datexis.model.Sentence;
import de.datexis.model.tag.Tag;
import de.datexis.sector.model.SectionAnnotation;
import java.util.Objects;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassTag
implements Tag {
    private static final Logger log = LoggerFactory.getLogger(ClassTag.class);
    protected final String label;
    protected final int numClasses;
    protected final double[] vector;
    protected double confidence = 0.0;
    protected final int index;

    public ClassTag(String label, INDArray vector) {
        this.vector = vector.transpose().toDoubleVector();
        this.label = label;
        this.index = this.getMaxIndex(vector);
        this.confidence = vector.maxNumber().doubleValue();
        this.numClasses = (int)vector.length();
    }

    @JsonIgnore
    private int getMaxIndex(INDArray v) {
        double max = Double.MIN_VALUE;
        int index = 0;
        int j = 0;
        while ((long)j < v.length()) {
            double d = v.getDouble((long)j);
            if (d > max) {
                index = j;
                max = d;
            }
            ++j;
        }
        return index;
    }

    public int getIndex() {
        return this.index;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public ClassTag setConfidence(double confidence) {
        this.confidence = confidence;
        return this;
    }

    public int getVectorSize() {
        return this.numClasses;
    }

    public INDArray getVector() {
        return Nd4j.create((double[])this.vector).transposei();
    }

    public String toString() {
        return this.label;
    }

    public String getTag() {
        return this.label;
    }

    public String getTag(int index) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean matches(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassTag other = (ClassTag)obj;
        return Objects.equals(this.label, other.label);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassTag)) {
            return false;
        }
        ClassTag classTag = (ClassTag)o;
        return Objects.equals(this.numClasses, classTag.numClasses) && Objects.equals(this.label, classTag.label);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.numClasses);
    }

    public static class Factory {
        protected final LookupCacheEncoder encoder;

        public Factory(LookupCacheEncoder encoder) {
            this.encoder = encoder;
        }

        public ClassTag create(String heading) {
            return new ClassTag(heading, this.encoder.oneHot(heading));
        }

        public ClassTag create(INDArray prediction) {
            return new ClassTag(this.encoder.getNearestNeighbour(prediction), prediction);
        }

        public void attachFromSectionAnnotations(Document doc, Annotation.Source source) {
            for (SectionAnnotation ann : doc.getAnnotations(source, SectionAnnotation.class)) {
                String clss = ann.getSectionLabel();
                INDArray vec = this.encoder.oneHot(clss);
                doc.streamSentencesInRange(ann.getBegin(), ann.getEnd(), false).forEach(s -> s.putTag(source, (Tag)new ClassTag(clss, vec)));
            }
            doc.setTagAvailable(source, ClassTag.class, true);
        }

        public void attachFromSentenceVectors(Document doc, Class<? extends Encoder> encoder, Annotation.Source source) {
            for (Sentence s : doc.getSentences()) {
                s.putTag(source, (Tag)this.create(s.getVector(encoder)));
            }
            doc.setTagAvailable(source, ClassTag.class, true);
        }
    }
}

