/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.ner;

import de.datexis.common.WordHelpers;
import de.datexis.model.Annotation;
import de.datexis.model.Document;
import de.datexis.model.Sentence;
import de.datexis.model.Token;
import de.datexis.model.tag.BIO2Tag;
import de.datexis.model.tag.BIOESTag;
import de.datexis.model.tag.Tag;
import de.datexis.tagger.AbstractIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MentionAnnotation
extends Annotation {
    private static final Logger log = LoggerFactory.getLogger(MentionAnnotation.class);
    protected String type;
    protected String refId;

    public MentionAnnotation(Annotation.Source source, int begin, int end, String type, List<Token> tokens) {
        super(source, WordHelpers.wordsToText(tokens), begin, end);
        this.type = type;
    }

    public MentionAnnotation(Annotation.Source source, String text, int begin, int end) {
        super(source, text, begin, end);
        this.type = "GENERIC";
    }

    public MentionAnnotation(Annotation.Source source, List<Token> tokens) {
        super(source, WordHelpers.tokensToText(tokens, (int)tokens.get(0).getBegin()), tokens.get(0).getBegin(), tokens.get(tokens.size() - 1).getEnd());
        this.type = "GENERIC";
    }

    public MentionAnnotation(Annotation.Source source, List<Token> tokens, double confidence) {
        super(source, WordHelpers.wordsToText(tokens), tokens.get(0).getBegin(), tokens.get(tokens.size() - 1).getEnd());
        this.setConfidence(confidence);
        this.type = "GENERIC";
    }

    public MentionAnnotation(Document doc, Annotation.Source source, List<Token> tokens, String type, double confidence) {
        this(source, tokens, confidence);
        this.setDocumentRef(doc);
        this.type = type == null || type.isEmpty() ? "GENERIC" : type;
    }

    @Deprecated
    protected MentionAnnotation() {
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRefId() {
        return this.refId;
    }

    public void setRefId(String id) {
        this.refId = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.begin;
        result = 31 * result + this.end;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MentionAnnotation other = (MentionAnnotation)((Object)obj);
        if (!this.matches(other)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.refId == null ? other.refId != null : !this.refId.equals(other.refId));
    }

    public String toString() {
        return "Annotation [begin=" + this.begin + ", end=" + this.end + ", type=" + this.type + "]";
    }

    public static MentionAnnotation createFromPositions(Annotation.Source source, Document doc, int begin, int end, String id, String type) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        boolean inside = false;
        for (Token t : doc.getTokens()) {
            if (!inside && t.getBegin() <= begin && t.getEnd() > begin) {
                inside = true;
                t.putTag(Annotation.Source.GOLD, (Tag)BIO2Tag.B());
                tokens.add(t);
                continue;
            }
            if (inside && t.getBegin() < end) {
                t.putTag(Annotation.Source.GOLD, (Tag)BIO2Tag.I());
                tokens.add(t);
                continue;
            }
            if (!inside || t.getBegin() < end) continue;
            inside = false;
            MentionAnnotation ann = new MentionAnnotation(source, begin, end, type, tokens);
            ann.setRefId(id);
            ann.setDocumentRef(doc);
            return ann;
        }
        if (inside) {
            MentionAnnotation ann = new MentionAnnotation(source, begin, end, type, tokens);
            ann.setRefId(id);
            ann.setDocumentRef(doc);
            return ann;
        }
        log.warn("Tokens not found for boundaries (" + begin + "," + end + "): " + doc.getText());
        return null;
    }

    public static void annotateFromTags(Iterable<Document> docs, Annotation.Source source, Class<? extends Tag> tagset) {
        for (Document d : docs) {
            MentionAnnotation.annotateFromTags(d, source, tagset);
        }
    }

    public static void annotateFromTags(Iterable<Document> docs, Annotation.Source source, Class<? extends Tag> tagset, String type) {
        for (Document d : docs) {
            MentionAnnotation.annotateFromTags(d, source, tagset, type);
        }
    }

    public static void annotateFromTags(AbstractIterator it, Annotation.Source source, Class<? extends Tag> tagset) {
        MentionAnnotation.annotateFromTags(it.getDocuments(), source, tagset);
    }

    public static void annotateFromTags(AbstractIterator it, Annotation.Source source, Class<? extends Tag> tagset, String type) {
        MentionAnnotation.annotateFromTags(it.getDocuments(), source, tagset, type);
    }

    public static void annotateFromTags(Document doc, Annotation.Source source, Class<? extends Tag> tagset) {
        MentionAnnotation.annotateFromTags(doc, source, tagset, "GENERIC");
    }

    public static void annotateFromTags(Document doc, Annotation.Source source, Class<? extends Tag> tagset, String type) {
        List<MentionAnnotation> anns = null;
        if (tagset.equals(BIO2Tag.class)) {
            anns = MentionAnnotation.createFromBIO2Tags(doc, source, type);
        } else if (tagset.equals(BIOESTag.class)) {
            BIOESTag.convertToBIO2((Document)doc, (Annotation.Source)source);
            anns = MentionAnnotation.createFromBIO2Tags(doc, source, type);
        } else {
            throw new IllegalArgumentException("Tagset " + tagset.getCanonicalName() + " not implemented");
        }
        if (anns != null) {
            doc.addAnnotations(anns);
        }
    }

    private static List<MentionAnnotation> createFromBIO2Tags(Document doc, Annotation.Source source, String defaultType) {
        ArrayList<MentionAnnotation> annotations = new ArrayList<MentionAnnotation>();
        ArrayList<Token> tokens = new ArrayList<Token>();
        double confidence = 0.0;
        String type = defaultType;
        for (Sentence s : doc.getSentences()) {
            for (Token t : s.getTokens()) {
                BIO2Tag tag = (BIO2Tag)t.getTag(source, BIO2Tag.class);
                if (tokens.isEmpty()) {
                    if (tag.isB()) {
                        tokens.add(t);
                        confidence = tag.getConfidence();
                        if (tag.getType() == null || tag.getType().isEmpty()) continue;
                        type = tag.getType();
                        continue;
                    }
                    if (!tag.isI()) continue;
                    tokens.add(t);
                    confidence = tag.getConfidence();
                    if (tag.getType() == null || tag.getType().isEmpty()) continue;
                    type = tag.getType();
                    continue;
                }
                if (tag.isB()) {
                    annotations.add(new MentionAnnotation(s.getDocumentRef(), source, tokens, type, confidence / (double)tokens.size()));
                    tokens.clear();
                    tokens.add(t);
                    confidence = tag.getConfidence();
                    if (tag.getType() == null || tag.getType().isEmpty()) continue;
                    type = tag.getType();
                    continue;
                }
                if (tag.isI()) {
                    tokens.add(t);
                    confidence += tag.getConfidence();
                    continue;
                }
                annotations.add(new MentionAnnotation(s.getDocumentRef(), source, tokens, type, confidence / (double)tokens.size()));
                tokens.clear();
                confidence = 0.0;
                type = defaultType;
            }
            if (tokens.isEmpty()) continue;
            annotations.add(new MentionAnnotation(s.getDocumentRef(), source, tokens, type, confidence / (double)tokens.size()));
            tokens.clear();
        }
        return annotations;
    }

    public static void createTagsFromAnnotations(Document doc, Annotation.Source source, Class<? extends Tag> tagset) {
        if (tagset.equals(BIOESTag.class)) {
            MentionAnnotation.createBIOESTagsFromAnnotations(doc, source);
        } else if (tagset.equals(BIO2Tag.class)) {
            MentionAnnotation.createBIOESTagsFromAnnotations(doc, source);
            BIOESTag.convertToBIO2((Document)doc, (Annotation.Source)source);
        } else {
            throw new IllegalArgumentException("Tagset " + tagset.getCanonicalName() + " not implemented");
        }
    }

    private static void createBIOESTagsFromAnnotations(Document doc, Annotation.Source source) {
        doc.streamAnnotations(source, MentionAnnotation.class).forEach(ann -> {
            List tokens = doc.streamTokensInRange(ann.getBegin(), ann.getEnd(), false).collect(Collectors.toList());
            if (tokens.isEmpty()) {
                log.warn("no Tokens in Annotation");
            } else if (tokens.size() == 1) {
                ((Token)tokens.get(0)).putTag(source, (Tag)BIOESTag.S());
            } else {
                int i = 0;
                ((Token)tokens.get(i)).putTag(source, (Tag)BIOESTag.B());
                while (++i < tokens.size() - 1) {
                    ((Token)tokens.get(i)).putTag(source, (Tag)BIOESTag.I());
                }
                ((Token)tokens.get(i)).putTag(source, (Tag)BIOESTag.E());
            }
        });
    }

    public static class Type {
        public static final String GENERIC = "GENERIC";
        public static final String ANY = "GENERIC";
        public static final String NOUNPHRASE = "NP";
        public static final String NOUN = "NOUN";
    }
}

