/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.ner;

import de.datexis.annotator.AnnotatorFactory;
import de.datexis.common.Resource;
import de.datexis.model.Document;
import de.datexis.ner.MentionAnnotator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericMentionAnnotator
extends MentionAnnotator {
    protected static final Logger log = LoggerFactory.getLogger(GenericMentionAnnotator.class);
    private static final Resource path = Resource.fromJAR((String)"models");
    private final MentionAnnotator annotatorEN = (MentionAnnotator)AnnotatorFactory.loadAnnotator((Resource)path.resolve("MentionAnnotator_en_NER-GENERIC_WikiNER+tri_20170309"), (Resource[])new Resource[0]);
    private final MentionAnnotator annotatorDE = (MentionAnnotator)AnnotatorFactory.loadAnnotator((Resource)path.resolve("MentionAnnotator_de_NER-GENERIC_WikiNER+tri_20170309"), (Resource[])new Resource[0]);

    public static MentionAnnotator create() {
        try {
            return new GenericMentionAnnotator();
        }
        catch (IOException ex) {
            log.error("Could not load packaged models for MentionAnnotator.");
            ex.printStackTrace();
            return null;
        }
    }

    protected GenericMentionAnnotator() throws IOException {
    }

    @Override
    public void annotate(Collection<Document> docs) {
        Map<String, List<Document>> groups = docs.stream().collect(Collectors.groupingBy(doc -> Optional.ofNullable(doc.getLanguage()).orElse("unk")));
        for (Map.Entry<String, List<Document>> group : groups.entrySet()) {
            if (group.getKey().equals("de")) {
                this.annotatorDE.annotate((Collection<Document>)group.getValue());
                continue;
            }
            if (group.getKey().equals("en")) {
                this.annotatorEN.annotate((Collection<Document>)group.getValue());
                continue;
            }
            log.warn("Detected language " + group.getKey() + ", using English annotator.");
            this.annotatorEN.annotate((Collection<Document>)group.getValue());
        }
    }
}

