/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.ner.exec;

import de.datexis.common.CommandLineParser;
import de.datexis.common.ObjectSerializer;
import de.datexis.common.Resource;
import de.datexis.model.Dataset;
import de.datexis.model.Document;
import de.datexis.ner.GenericMentionAnnotator;
import de.datexis.ner.MentionAnnotator;
import de.datexis.reader.RawTextDatasetReader;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunMentionAnnotator {
    protected static final Logger log = LoggerFactory.getLogger(RunMentionAnnotator.class);

    public static void main(String[] args) throws IOException {
        ExecParams params = new ExecParams();
        CommandLineParser parser = new CommandLineParser((CommandLineParser.Options)params);
        try {
            parser.parse(args);
            new RunMentionAnnotator().runAnnotator(params);
            System.exit(0);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("texoo-annotate-ner", "TeXoo: run pre-trained MentionAnnotator model", params.setUpCliOptions(), "", true);
            System.exit(1);
        }
    }

    protected void runAnnotator(ExecParams params) throws IOException {
        Resource inputPath = Resource.fromDirectory((String)params.inputFiles);
        Resource outputPath = params.outputPath != null ? Resource.fromDirectory((String)params.outputPath) : null;
        Dataset data = new RawTextDatasetReader().read(inputPath);
        MentionAnnotator ner = GenericMentionAnnotator.create();
        ner.annotate(data.getDocuments());
        if (params.outputPath != null) {
            if (!outputPath.exists()) {
                outputPath.toFile().mkdirs();
            }
            for (Document doc : data.getDocuments()) {
                ObjectSerializer.writeJSON((Object)doc, (Resource)outputPath.resolve(doc.getId() + ".json"));
            }
        } else {
            System.out.print(ObjectSerializer.getJSON((Object)data));
        }
    }

    protected static class ExecParams
    implements CommandLineParser.Options {
        protected String inputFiles;
        protected String outputPath = null;
        protected String language = null;

        protected ExecParams() {
        }

        public void setParams(CommandLine parse) {
            this.inputFiles = parse.getOptionValue("i");
            this.outputPath = parse.getOptionValue("o");
        }

        public Options setUpCliOptions() {
            Options op = new Options();
            op.addRequiredOption("i", "input", true, "path or file name for raw input text");
            op.addOption("o", "output", true, "path to create and store the output JSON, otherwise dump to stdout");
            return op;
        }
    }
}

