/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.ner.eval;

import com.google.common.collect.Lists;
import de.datexis.evaluation.ModelEvaluation;
import de.datexis.model.Annotation;
import de.datexis.model.Dataset;
import de.datexis.model.Document;
import de.datexis.model.Token;
import de.datexis.model.tag.BIO2Tag;
import de.datexis.ner.MentionAnnotation;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.nd4j.linalg.primitives.Counter;

@Deprecated
public class MentionAnnotatorEval
extends ModelEvaluation {
    Annotation.Source expectedSource;
    Annotation.Source predictedSource;

    public MentionAnnotatorEval(String experimentName) {
        this(experimentName, Annotation.Source.GOLD, Annotation.Source.PRED);
    }

    public MentionAnnotatorEval(String experimentName, Annotation.Source expected, Annotation.Source predicted) {
        super(experimentName);
        this.expectedSource = expected;
        this.predictedSource = predicted;
    }

    @Deprecated
    public MentionAnnotatorEval(String experimentName, Dataset train, Dataset test) {
        super(experimentName, train, test);
    }

    public void clear() {
        this.counts = new TreeMap();
        this.counts.put(ModelEvaluation.Measure.TP, new Counter());
        this.counts.put(ModelEvaluation.Measure.FP, new Counter());
        this.counts.put(ModelEvaluation.Measure.TN, new Counter());
        this.counts.put(ModelEvaluation.Measure.FN, new Counter());
    }

    public void evaluateAnnotations() {
        int i = 0;
        for (Document d : this.test.getDocuments()) {
            ((Counter)this.counts.get(ModelEvaluation.Measure.TP)).setCount((Object)i, this.getTP(d));
            ((Counter)this.counts.get(ModelEvaluation.Measure.FP)).setCount((Object)i, this.getFP(d));
            ((Counter)this.counts.get(ModelEvaluation.Measure.TN)).setCount((Object)i, this.getTN(d));
            ((Counter)this.counts.get(ModelEvaluation.Measure.FN)).setCount((Object)i, this.getFN(d));
            ++i;
        }
        ((Counter)this.counts.get(ModelEvaluation.Measure.TP)).removeKey((Object)-1);
        ((Counter)this.counts.get(ModelEvaluation.Measure.FP)).removeKey((Object)-1);
        ((Counter)this.counts.get(ModelEvaluation.Measure.TN)).removeKey((Object)-1);
        ((Counter)this.counts.get(ModelEvaluation.Measure.FN)).removeKey((Object)-1);
    }

    public double getTP() {
        return ((Counter)this.counts.get(ModelEvaluation.Measure.TP)).totalCount();
    }

    public double getFP() {
        return ((Counter)this.counts.get(ModelEvaluation.Measure.FP)).totalCount();
    }

    public double getTN() {
        return ((Counter)this.counts.get(ModelEvaluation.Measure.TN)).totalCount();
    }

    public double getFN() {
        return ((Counter)this.counts.get(ModelEvaluation.Measure.FN)).totalCount();
    }

    private double getTP(Document d) {
        int result = 0;
        ArrayList predicted = Lists.newArrayList(d.streamAnnotations(this.predictedSource, MentionAnnotation.class).iterator());
        ArrayList expected = Lists.newArrayList(d.streamAnnotations(this.expectedSource, MentionAnnotation.class).iterator());
        block0: for (MentionAnnotation pred : predicted) {
            for (MentionAnnotation exp : expected) {
                if (!pred.matches(exp, Annotation.Match.STRONG)) continue;
                ++result;
                continue block0;
            }
        }
        return result;
    }

    private double getFP(Document d) {
        int result = 0;
        ArrayList predicted = Lists.newArrayList(d.streamAnnotations(this.predictedSource, MentionAnnotation.class).iterator());
        ArrayList expected = Lists.newArrayList(d.streamAnnotations(this.expectedSource, MentionAnnotation.class).iterator());
        for (MentionAnnotation pred : predicted) {
            boolean found = false;
            for (MentionAnnotation exp : expected) {
                if (!exp.matches(pred, Annotation.Match.STRONG)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++result;
        }
        return result;
    }

    private double getTN(Document d) {
        return 0.0;
    }

    private double getFN(Document d) {
        int result = 0;
        ArrayList predicted = Lists.newArrayList(d.streamAnnotations(this.predictedSource, MentionAnnotation.class).iterator());
        ArrayList expected = Lists.newArrayList(d.streamAnnotations(this.expectedSource, MentionAnnotation.class).iterator());
        for (MentionAnnotation exp : expected) {
            boolean found = false;
            for (MentionAnnotation pred : predicted) {
                if (!pred.matches(exp, Annotation.Match.STRONG)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++result;
        }
        return result;
    }

    public double precision() {
        return this.getMicroPrecision(this.test);
    }

    private double getMicroPrecision(Dataset data) {
        double correct = 0.0;
        double foundGuessed = 0.0;
        for (Document d : data.getDocuments()) {
            correct += this.getTP(d);
        }
        for (Document d : data.getDocuments()) {
            foundGuessed += this.getTP(d) + this.getFP(d);
        }
        if (foundGuessed > 0.0) {
            return correct / foundGuessed;
        }
        return 0.0;
    }

    private double getMacroPrecision(Dataset data) {
        double prec = 0.0;
        for (Document d : data.getDocuments()) {
            prec += this.getTP(d) / (this.getTP(d) + this.getFP(d));
        }
        return prec / (double)data.countDocuments();
    }

    public double recall() {
        return this.getMicroRecall(this.test);
    }

    public double getMicroRecall(Dataset data) {
        double correct = 0.0;
        double foundCorrect = 0.0;
        for (Document d : data.getDocuments()) {
            correct += this.getTP(d);
        }
        for (Document d : data.getDocuments()) {
            foundCorrect += this.getTP(d) + this.getFN(d);
        }
        if (foundCorrect > 0.0) {
            return correct / foundCorrect;
        }
        return 0.0;
    }

    private double getMacroRecall(Dataset data) {
        double prec = 0.0;
        for (Document d : data.getDocuments()) {
            prec += this.getTP(d) / (this.getTP(d) + this.getFN(d));
        }
        return prec / (double)data.countDocuments();
    }

    public double getTAccuracy(Dataset data) {
        double count = 0.0;
        double correct = 0.0;
        for (Token t : data.streamTokens().collect(Collectors.toList())) {
            if (((BIO2Tag)t.getTag(this.expectedSource, BIO2Tag.class)).get().equals((Object)((BIO2Tag)t.getTag(this.predictedSource, BIO2Tag.class)).get())) {
                correct += 1.0;
            }
            count += 1.0;
        }
        return correct / count;
    }

    public double f1() {
        return this.getMicroF1(this.test);
    }

    public double getMicroF1(Dataset data) {
        return 2.0 * this.getMicroPrecision(data) * this.getMicroRecall(data) / (this.getMicroPrecision(data) + this.getMicroRecall(data));
    }

    private double getMacroF1(Dataset data) {
        return 2.0 * this.getMacroPrecision(data) * this.getMacroRecall(data) / (this.getMacroPrecision(data) + this.getMacroRecall(data));
    }

    public String printAnnotationStats() {
        StringBuilder line = new StringBuilder();
        line.append("ANNOTATION [micro-avg]\n").append("#Docs\t#Tokns\t#Anns\t#Pred\t#TP\t#FP\t#TN\t#FN\tTAcc\tPrec\tRec\tF1");
        line.append("\n");
        line.append(this.fInt(this.test.countDocuments())).append("\t");
        line.append(this.fInt(this.test.countTokens())).append("\t");
        line.append(this.fInt(this.test.countAnnotations(this.expectedSource))).append("\t");
        line.append(this.fInt(this.test.countAnnotations(this.predictedSource))).append("\t");
        line.append(this.fInt(((Counter)this.counts.get(ModelEvaluation.Measure.TP)).totalCount())).append("\t");
        line.append(this.fInt(((Counter)this.counts.get(ModelEvaluation.Measure.FP)).totalCount())).append("\t");
        line.append(this.fInt(((Counter)this.counts.get(ModelEvaluation.Measure.TN)).totalCount())).append("\t");
        line.append(this.fInt(((Counter)this.counts.get(ModelEvaluation.Measure.FN)).totalCount())).append("\t");
        line.append(this.fDbl(this.getTAccuracy(this.test))).append("\t");
        line.append(this.fDbl(this.getMicroPrecision(this.test))).append("\t");
        line.append(this.fDbl(this.getMicroRecall(this.test))).append("\t");
        line.append(this.fDbl(this.getMicroF1(this.test))).append("\t");
        line.append("\n");
        System.out.println(line.toString());
        return line.toString();
    }
}

