/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.ner.eval;

import com.google.common.collect.Lists;
import de.datexis.annotator.AnnotatorEvaluation;
import de.datexis.model.Annotation;
import de.datexis.model.Dataset;
import de.datexis.model.Document;
import de.datexis.model.Token;
import de.datexis.model.tag.BIO2Tag;
import de.datexis.ner.MentionAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.nd4j.linalg.primitives.Counter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MentionAnnotatorEvaluation
extends AnnotatorEvaluation {
    protected static Logger log = LoggerFactory.getLogger(MentionAnnotatorEvaluation.class);
    protected TreeMap<AnnotatorEvaluation.Measure, Counter<Integer>> counts;
    Annotation.Match matchingStrategy;

    public MentionAnnotatorEvaluation(String experimentName, Annotation.Match matchingStrategy) {
        this(experimentName, Annotation.Source.GOLD, Annotation.Source.PRED, matchingStrategy);
    }

    public MentionAnnotatorEvaluation(String experimentName, Annotation.Source expected, Annotation.Source predicted, Annotation.Match matchingStrategy) {
        super(experimentName, expected, predicted);
        log = LoggerFactory.getLogger(MentionAnnotatorEvaluation.class);
        this.matchingStrategy = matchingStrategy;
        this.clear();
    }

    protected void clear() {
        this.counts = new TreeMap();
        this.counts.put(AnnotatorEvaluation.Measure.TP, (Counter<Integer>)new Counter());
        this.counts.put(AnnotatorEvaluation.Measure.FP, (Counter<Integer>)new Counter());
        this.counts.put(AnnotatorEvaluation.Measure.TN, (Counter<Integer>)new Counter());
        this.counts.put(AnnotatorEvaluation.Measure.FN, (Counter<Integer>)new Counter());
        this.countExamples = 0;
        this.countAnnotations = 0;
        this.countDocs = 0;
        this.countSentences = 0;
        this.countTokens = 0;
    }

    protected double getCount(AnnotatorEvaluation.Measure m, int classIdx) {
        return this.counts.get(m).getCount((Object)classIdx);
    }

    public double getScore() {
        return this.getMicroF1();
    }

    public void calculateScores(Dataset dataset) {
        this.calculateScoresFromAnnotations(dataset.getDocuments(), MentionAnnotation.class);
    }

    public void calculateScores(Collection<Document> docs) {
        this.calculateScoresFromAnnotations(docs, MentionAnnotation.class);
    }

    public void calculateScoresFromAnnotations(Collection<Document> docs, Class<? extends Annotation> annotationClass) {
        int i = 0;
        for (Document d : docs) {
            this.counts.get(AnnotatorEvaluation.Measure.TP).setCount((Object)i, this.getTP(d, annotationClass));
            this.counts.get(AnnotatorEvaluation.Measure.FP).setCount((Object)i, this.getFP(d, annotationClass));
            this.counts.get(AnnotatorEvaluation.Measure.TN).setCount((Object)i, this.getTN(d, annotationClass));
            this.counts.get(AnnotatorEvaluation.Measure.FN).setCount((Object)i, this.getFN(d, annotationClass));
            this.countTokens += d.countTokens();
            this.countSentences += d.countSentences();
            this.countAnnotations = (int)((long)this.countAnnotations + d.countAnnotations(this.expectedSource, annotationClass));
            ++this.countDocs;
            ++i;
        }
        this.fixCounters();
    }

    protected void fixCounters() {
        this.counts.get(AnnotatorEvaluation.Measure.TP).removeKey((Object)-1);
        this.counts.get(AnnotatorEvaluation.Measure.FP).removeKey((Object)-1);
        this.counts.get(AnnotatorEvaluation.Measure.TN).removeKey((Object)-1);
        this.counts.get(AnnotatorEvaluation.Measure.FN).removeKey((Object)-1);
    }

    public double getTP(Document d, Class<? extends Annotation> annotationClass) {
        int result = 0;
        ArrayList predicted = Lists.newArrayList(d.streamAnnotations(this.predictedSource, annotationClass).iterator());
        ArrayList expected = Lists.newArrayList(d.streamAnnotations(this.expectedSource, annotationClass).iterator());
        block0: for (Annotation pred : predicted) {
            for (Annotation exp : expected) {
                if (!pred.matches(exp, this.matchingStrategy)) continue;
                ++result;
                continue block0;
            }
        }
        this.countExamples += result;
        return result;
    }

    public double getFP(Document d, Class<? extends Annotation> annotationClass) {
        int result = 0;
        ArrayList predicted = Lists.newArrayList(d.streamAnnotations(this.predictedSource, annotationClass).iterator());
        ArrayList expected = Lists.newArrayList(d.streamAnnotations(this.expectedSource, annotationClass).iterator());
        for (Annotation pred : predicted) {
            boolean found = false;
            for (Annotation exp : expected) {
                if (!exp.matches(pred, this.matchingStrategy)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++result;
        }
        this.countExamples += result;
        return result;
    }

    public double getTN(Document d, Class<? extends Annotation> annotationClass) {
        return 0.0;
    }

    public double getFN(Document d, Class<? extends Annotation> annotationClass) {
        int result = 0;
        ArrayList predicted = Lists.newArrayList(d.streamAnnotations(this.predictedSource, annotationClass).iterator());
        ArrayList expected = Lists.newArrayList(d.streamAnnotations(this.expectedSource, annotationClass).iterator());
        for (Annotation exp : expected) {
            boolean found = false;
            for (Annotation pred : predicted) {
                if (!pred.matches(exp, Annotation.Match.STRONG)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++result;
        }
        return result;
    }

    public double getTP() {
        return this.counts.get(AnnotatorEvaluation.Measure.TP).totalCount();
    }

    public double getFP() {
        return this.counts.get(AnnotatorEvaluation.Measure.FP).totalCount();
    }

    public double getTN() {
        return this.counts.get(AnnotatorEvaluation.Measure.TN).totalCount();
    }

    public double getFN() {
        return this.counts.get(AnnotatorEvaluation.Measure.FN).totalCount();
    }

    protected double div(double n, double d) {
        if (d == 0.0) {
            return 0.0;
        }
        return n / d;
    }

    public double getTokenAccuracy(Dataset data) {
        double count = 0.0;
        double correct = 0.0;
        for (Token t : data.streamTokens().collect(Collectors.toList())) {
            if (((BIO2Tag)t.getTag(this.expectedSource, BIO2Tag.class)).get().equals((Object)((BIO2Tag)t.getTag(this.predictedSource, BIO2Tag.class)).get())) {
                correct += 1.0;
            }
            count += 1.0;
        }
        return correct / count;
    }

    public double getAccuracy() {
        double found = this.getTP();
        double correct = this.getTP() + this.getFN();
        if (correct > 0.0) {
            return found / correct;
        }
        return 0.0;
    }

    protected double getAccuracy(int c) {
        return this.div(this.getCount(AnnotatorEvaluation.Measure.TP, c), this.getCount(AnnotatorEvaluation.Measure.TP, c) + this.getCount(AnnotatorEvaluation.Measure.FN, c));
    }

    public double getMicroPrecision() {
        double correct = this.getTP();
        double foundGuessed = this.getTP() + this.getFP();
        if (foundGuessed > 0.0) {
            return correct / foundGuessed;
        }
        return 0.0;
    }

    public double getMacroPrecision() {
        double score = 0.0;
        int count = 0;
        for (int i = 0; i < this.countDocs; ++i) {
            if (!(this.getCount(AnnotatorEvaluation.Measure.FP, i) > 0.0)) continue;
            score += this.getPrecision(i);
            ++count;
        }
        if (count > 0) {
            return score / (double)count;
        }
        return 0.0;
    }

    protected double getPrecision(int c) {
        if (this.getCount(AnnotatorEvaluation.Measure.TP, c) == 0.0) {
            return 0.0;
        }
        return this.div(this.getCount(AnnotatorEvaluation.Measure.TP, c), this.getCount(AnnotatorEvaluation.Measure.TP, c) + this.getCount(AnnotatorEvaluation.Measure.FP, c));
    }

    public double getMicroRecall() {
        double correct = this.getTP();
        double foundCorrect = this.getTP() + this.getFN();
        if (foundCorrect > 0.0) {
            return correct / foundCorrect;
        }
        return 0.0;
    }

    public double getMacroRecall() {
        double score = 0.0;
        int count = 0;
        for (int i = 0; i < this.countDocs; ++i) {
            if (!(this.getCount(AnnotatorEvaluation.Measure.FN, i) > 0.0)) continue;
            score += this.getRecall(i);
            ++count;
        }
        if (count > 0) {
            return score / (double)count;
        }
        return 0.0;
    }

    protected double getRecall(int c) {
        if (this.getCount(AnnotatorEvaluation.Measure.TP, c) == 0.0) {
            return 0.0;
        }
        return this.div(this.getCount(AnnotatorEvaluation.Measure.TP, c), this.getCount(AnnotatorEvaluation.Measure.TP, c) + this.getCount(AnnotatorEvaluation.Measure.FN, c));
    }

    public double getMicroF1() {
        return this.getF1(this.getMicroPrecision(), this.getMicroRecall());
    }

    public double getMacroF1() {
        return this.getF1(this.getMacroPrecision(), this.getMacroRecall());
    }

    protected double getF1(int i) {
        return this.getF1(this.getPrecision(i), this.getRecall(i));
    }

    private double getF1(double precision, double recall) {
        if (precision + recall == 0.0) {
            return 0.0;
        }
        return 2.0 * precision * recall / (precision + recall);
    }

    public String printAnnotationStats() {
        return MentionAnnotatorEvaluation.printHeader() + this.printRow();
    }

    public static String printHeader() {
        StringBuilder line = new StringBuilder();
        line.append("ANNOTATION [micro-avg]\n").append("Experiment ----------------------------------------\t#Docs\t#Tokns\t#Anns\t#Pred\t#TP\t#FP\t#TN\t#FN\tPrec\tRec\tF1");
        line.append("\n");
        System.out.print(line.toString());
        return line.toString();
    }

    public String printRow() {
        StringBuilder line = new StringBuilder();
        line.append(MentionAnnotatorEvaluation.fStr((String)this.experimentName, (int)50)).append("\t");
        line.append(MentionAnnotatorEvaluation.fInt((double)this.countDocuments())).append("\t");
        line.append(MentionAnnotatorEvaluation.fInt((double)this.countTokens())).append("\t");
        line.append(MentionAnnotatorEvaluation.fInt((double)this.countAnnotations())).append("\t");
        line.append(MentionAnnotatorEvaluation.fInt((double)this.countExamples())).append("\t");
        line.append(MentionAnnotatorEvaluation.fInt((double)this.getTP())).append("\t");
        line.append(MentionAnnotatorEvaluation.fInt((double)this.getFP())).append("\t");
        line.append(MentionAnnotatorEvaluation.fInt((double)this.getTN())).append("\t");
        line.append(MentionAnnotatorEvaluation.fInt((double)this.getFN())).append("\t");
        line.append(MentionAnnotatorEvaluation.fDbl((double)this.getMicroPrecision())).append("\t");
        line.append(MentionAnnotatorEvaluation.fDbl((double)this.getMicroRecall())).append("\t");
        line.append(MentionAnnotatorEvaluation.fDbl((double)this.getMicroF1())).append("\t");
        line.append("\n");
        System.out.print(line.toString());
        return line.toString();
    }
}

