/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.index.impl;

import de.datexis.common.Resource;
import de.datexis.encoder.LookupCacheEncoder;
import de.datexis.index.WordIndex;
import de.datexis.index.impl.LuceneIndex;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.icu.ICUFoldingFilterFactory;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerFactory;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneWordIndex
extends LuceneIndex
implements WordIndex {
    protected static final Logger log = LoggerFactory.getLogger(LuceneWordIndex.class);
    protected static final String FIELD_WORDS = "words";
    protected static final String FIELD_TEXT = "text";
    protected static final String FIELD_ID = "id";
    protected static final String PARAM_PROXIMITY = "2";
    protected static final String PARAM_FUZZY = "0.8";
    protected static final int NUM_CANDIDATES = 1000;

    public LuceneWordIndex() {
    }

    public LuceneWordIndex(Iterable<String> texts) {
        this.createIndexRAM(texts);
    }

    public LuceneWordIndex(LookupCacheEncoder encoder) {
        this.createIndexRAM(encoder.getWords());
    }

    public void createIndexRAM(Iterable<String> texts) {
        try {
            RAMDirectory index = new RAMDirectory();
            this.createIndex(texts, (Directory)index);
            this.openIndex((Directory)index);
        }
        catch (IOException e) {
            log.error(e.toString());
        }
    }

    public void createIndexDirectory(Iterable<String> texts, Resource cacheDir) throws IOException {
        FSDirectory index = FSDirectory.open((Path)cacheDir.getPath());
        this.createIndex(texts, (Directory)index);
        this.openIndex((Directory)index);
    }

    public void createIndex(Iterable<String> texts, Directory index) {
        log.info("creating new WordIndex...");
        this.analyzer = this.buildAnalyzer();
        try {
            IndexWriterConfig config = new IndexWriterConfig(this.analyzer);
            IndexWriter writer = new IndexWriter(index, config);
            int num = 0;
            int empty = 0;
            log.info("writing words...");
            for (String text : texts) {
                Document doc = this.createLuceneDocument(text);
                writer.addDocument((Iterable)doc);
                if (++num % 100000 != 0) continue;
                log.info("wrote " + num + " entries so far");
            }
            writer.close();
            log.info(num + " texts (" + empty + " empty) written to index");
        }
        catch (IOException e) {
            log.error(e.toString());
        }
    }

    @Override
    public List<String> queryText(String text, int hits) {
        try {
            Query exactQ = new QueryParser(FIELD_WORDS, this.analyzer).parse("\"" + text + "\"~" + PARAM_PROXIMITY);
            return this.queryIndex(exactQ, hits);
        }
        catch (Exception ex) {
            log.error(ex.toString());
            return new ArrayList<String>();
        }
    }

    @Override
    public List<String> queryExactText(String text, int hits) {
        try {
            Query exactQ = new QueryParser(FIELD_TEXT, this.analyzer).parse("\"" + text + "\"");
            return this.queryIndex(exactQ, hits);
        }
        catch (Exception ex) {
            log.error(ex.toString());
            return new ArrayList<String>();
        }
    }

    @Override
    public List<String> queryPrefixText(String prefix, int hits) {
        try {
            prefix = prefix.replaceAll("\\s+", "\\\\ ");
            Query prefixQ = new QueryParser(FIELD_TEXT, this.analyzer).parse("" + prefix + "*");
            log.info(prefixQ.toString());
            return this.queryIndex(prefixQ, hits);
        }
        catch (Exception ex) {
            log.error(ex.toString());
            return new ArrayList<String>();
        }
    }

    private Document createLuceneDocument(String text) {
        Document doc = new Document();
        this.addTextField(doc, FIELD_TEXT, text.trim(), Field.Store.YES);
        this.addTextField(doc, FIELD_WORDS, text.trim(), Field.Store.NO);
        return doc;
    }

    @Override
    protected Analyzer buildAnalyzer() {
        TreeMap<String, CustomAnalyzer> analyzers = new TreeMap<String, CustomAnalyzer>();
        try {
            CustomAnalyzer wordAnalyzer = CustomAnalyzer.builder().withTokenizer(ICUTokenizerFactory.class, new String[0]).addTokenFilter(ICUFoldingFilterFactory.class, new String[0]).build();
            CustomAnalyzer stringAnalyzer = CustomAnalyzer.builder().withTokenizer(KeywordTokenizerFactory.class, new String[0]).addTokenFilter(ICUFoldingFilterFactory.class, new String[0]).build();
            analyzers.put(FIELD_WORDS, wordAnalyzer);
            analyzers.put(FIELD_TEXT, stringAnalyzer);
        }
        catch (IOException e) {
            log.error("Could not create Lucene Analyzer: ");
            log.error(e.toString());
        }
        return new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), analyzers);
    }

    protected List<String> queryIndex(Query query, int hits) {
        ArrayList<String> result = new ArrayList<String>(hits);
        try {
            ScoreDoc[] docs;
            TopDocs top = this.searcher.search(query, hits);
            for (ScoreDoc hit : docs = top.scoreDocs) {
                Document d = this.searcher.doc(hit.doc);
                result.add(d.get(FIELD_TEXT));
            }
        }
        catch (Exception ex) {
            log.error(ex.toString());
        }
        return result;
    }
}

