/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.index;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.datexis.nel.model.Article;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WikiDataArticle
extends Article {
    public Map<String, String> refIDs;
    public Map<String, String> refURLs;
    public Set<String> types;

    public WikiDataArticle() {
        this.refIDs = new TreeMap<String, String>();
        this.refURLs = new TreeMap<String, String>();
        this.types = new TreeSet<String>();
    }

    public WikiDataArticle(String id, String title, String type, Map<String, String> refIDs, Map<String, String> refURLs, String description, Set<String> names, Set<String> terms) {
        this.id = id;
        this.title = title;
        this.type = type;
        this.refIDs = new TreeMap<String, String>(refIDs);
        this.refURLs = new TreeMap<String, String>(refURLs);
        this.types = new TreeSet<String>();
        this.description = description;
        this.names = names;
        this.terms = terms;
    }

    public void setTypes(Set<String> types) {
        this.types = types;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public void addType(String type) {
        this.types.add(type);
    }

    public Map<String, String> getRefIDs() {
        return this.refIDs;
    }

    @JsonIgnore
    public Map<String, String> getRefURLs() {
        return this.refURLs;
    }

    public void putRefID(RefID key, String value) {
        if (value != null) {
            this.refIDs.put(key.toString().toLowerCase(), value);
        }
    }

    @JsonIgnore
    public String getRefID(RefID key) {
        return this.refIDs.getOrDefault(key.toString().toLowerCase(), null);
    }

    @JsonIgnore
    public String getRefURL(String key) {
        return this.refURLs.getOrDefault(key, null);
    }

    @Override
    @JsonIgnore
    public String getType() {
        return super.getType();
    }

    @JsonIgnore
    public int getBegin() {
        return super.getBegin();
    }

    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @Override
    @JsonIgnore
    public String getText() {
        return super.getText();
    }

    public String toString() {
        if (this.getTitle() != null && this.getId().equals("NIL")) {
            return "NIL";
        }
        return this.getTitle() + " (" + this.getId() + ")";
    }

    public static enum RefID {
        WIKIDATA,
        FREEBASE,
        WIKIPEDIA,
        UMLS,
        ICD10;

    }
}

