/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.index;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.datexis.common.Resource;
import de.datexis.index.ArticleIndex;
import de.datexis.index.WikiDataArticle;
import de.datexis.index.impl.KNNArticleIndex;
import de.datexis.index.impl.LuceneArticleIndex;
import de.datexis.index.impl.VectorArticleIndex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArticleIndexFactory {
    protected static final Logger log = LoggerFactory.getLogger(ArticleIndexFactory.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public static LuceneArticleIndex loadWikiDataIndex(Resource file) throws IOException {
        return ArticleIndexFactory.loadWikiDataIndex(file, null, null, LuceneArticleIndex.class);
    }

    public static LuceneArticleIndex loadWikiDataIndex(Resource file, Resource cacheDir) throws IOException {
        return ArticleIndexFactory.loadWikiDataIndex(file, null, cacheDir, LuceneArticleIndex.class);
    }

    public static VectorArticleIndex loadWikiDataIndex(Resource file, Resource parvec, Resource cacheDir) throws IOException {
        return ArticleIndexFactory.loadWikiDataIndex(file, parvec, cacheDir, VectorArticleIndex.class);
    }

    protected static <T extends ArticleIndex> T loadWikiDataIndex(Resource file, Resource parvec, Resource cacheDir, Class<T> type) throws IOException {
        log.info("Reading WikiData index from " + file.toString());
        try (InputStream in = file.getInputStream();){
            LuceneArticleIndex index = null;
            index = type.equals(VectorArticleIndex.class) ? new VectorArticleIndex(parvec) : (type.equals(KNNArticleIndex.class) ? new KNNArticleIndex(parvec) : new LuceneArticleIndex());
            String cacheName = file.getFileName().replaceFirst("\\.json(\\.gz)?$", "");
            if (type.equals(VectorArticleIndex.class)) {
                cacheName = cacheName + "+parvec";
            }
            if (cacheDir != null && index.openIndex(cacheDir.resolve("/" + cacheName + "/"))) {
                LuceneArticleIndex luceneArticleIndex = index;
                return (T)luceneArticleIndex;
            }
            CharsetDecoder utf8 = StandardCharsets.UTF_8.newDecoder();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, utf8));
            Stream<WikiDataArticle> articles = br.lines().filter(line -> !line.isEmpty()).map(json -> ArticleIndexFactory.convert(json)).filter(obj -> obj != null);
            if (cacheDir != null) {
                index.createIndexDirectory(articles.iterator(), cacheDir.resolve("/" + cacheName + "/"));
            } else {
                index.createIndexRAM(articles.iterator());
            }
            LuceneArticleIndex luceneArticleIndex = index;
            return (T)luceneArticleIndex;
        }
    }

    private static WikiDataArticle convert(String json) {
        try {
            return (WikiDataArticle)((Object)mapper.readerFor(WikiDataArticle.class).readValue(json));
        }
        catch (IOException ex) {
            log.warn("Could not parse JSON: " + ex.toString());
            return null;
        }
    }
}

