/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.nel.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.datexis.model.Span;
import java.util.Set;
import java.util.TreeSet;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
public class Article
extends Span {
    protected static final Logger log = LoggerFactory.getLogger(Article.class);
    protected String id;
    protected String url;
    protected String title;
    protected String text;
    protected String description;
    protected String type;
    protected Set<String> names;
    protected Set<String> terms = new TreeSet<String>();
    protected INDArray vector;

    public Article(String id, String url, String title, String text) {
        this.names = new TreeSet<String>();
        this.id = id;
        this.url = url;
        this.title = title;
        this.text = text;
        this.begin = 0;
        if (text != null) {
            this.setLength(text.length());
        } else {
            this.setLength(0);
        }
    }

    public Article() {
        this.names = new TreeSet<String>();
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addTerm(String term) {
        this.terms.add(term);
    }

    public void addName(String name) {
        this.names.add(name);
    }

    public void setNames(Set<String> names) {
        this.names = names;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public void setTerms(Set<String> terms) {
        this.terms = terms;
    }

    public Set<String> getTerms() {
        return this.terms;
    }

    @JsonIgnore
    public INDArray getVector() {
        return this.vector;
    }

    public void setVector(INDArray vector) {
        this.vector = vector;
    }
}

