/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.nel;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Objects;
import de.datexis.index.ArticleRef;
import de.datexis.model.Annotation;
import de.datexis.ner.MentionAnnotation;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NamedEntityAnnotation
extends Annotation {
    protected String type;
    protected String refName;
    protected String refId;
    protected String refUrl;
    protected List<ArticleRef> candidates = new ArrayList<ArticleRef>();

    public NamedEntityAnnotation() {
    }

    public NamedEntityAnnotation(Annotation.Source source, String text, int begin, int length, String type, String annotationSource) {
        super(source, text, begin, begin + length);
        this.type = type;
    }

    public NamedEntityAnnotation(MentionAnnotation ann, List<ArticleRef> candidates) {
        super((Annotation)ann);
        this.type = ann.getType();
        this.confidence = ann.getConfidence();
        this.candidates = candidates;
        if (candidates != null && !candidates.isEmpty()) {
            this.refName = candidates.get(0).getTitle();
            this.refId = candidates.get(0).getId();
            this.refUrl = candidates.get(0).getUrl();
        } else {
            this.refId = "NIL";
        }
    }

    public NamedEntityAnnotation(NamedEntityAnnotation ann, List<ArticleRef> candidates) {
        super((Annotation)ann);
        this.refName = ann.refName;
        this.refId = ann.refId;
        this.type = ann.type;
        this.confidence = ann.getConfidence();
        this.candidates = candidates;
        if (candidates != null && !candidates.isEmpty()) {
            this.refName = candidates.get(0).getTitle();
            this.refId = candidates.get(0).getId();
            this.refUrl = candidates.get(0).getUrl();
        } else {
            this.refId = "NIL";
        }
    }

    public String getRefName() {
        return this.refName;
    }

    public void setRefName(String refName) {
        this.refName = refName;
    }

    public String getRefId() {
        return this.refId;
    }

    public void setRefId(String id) {
        this.refId = id;
    }

    public String getRefUrl() {
        return this.refUrl;
    }

    public void setRefUrl(String url) {
        this.refUrl = url;
    }

    public void setCandidates(List<ArticleRef> candidates, boolean setId) {
        this.candidates = candidates;
        if (setId) {
            if (candidates != null && !candidates.isEmpty()) {
                this.refName = candidates.get(0).getTitle();
                this.refId = candidates.get(0).getId();
                this.refUrl = candidates.get(0).getUrl();
            } else {
                this.refId = "NIL";
            }
        }
    }

    public String toString() {
        if (this.getRefId() != null && this.getRefId().equals("NIL")) {
            return "NIL";
        }
        return this.getRefName() + " (" + this.getRefId() + ")";
    }

    public String getType() {
        return this.type;
    }

    public List<ArticleRef> getCandidates() {
        return this.candidates;
    }

    public boolean matches(Annotation other, Annotation.Match match) {
        if (other instanceof NamedEntityAnnotation) {
            NamedEntityAnnotation that = (NamedEntityAnnotation)other;
            return super.matches((Annotation)that, match) && (this.getRefId() != null && that.getRefId() != null && Objects.equal((Object)this.getRefId(), (Object)that.getRefId()) || this.getRefUrl() != null && that.getRefUrl() != null && Objects.equal((Object)this.getRefUrl(), (Object)that.getRefUrl()));
        }
        return false;
    }
}

