/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.index.impl;

import de.datexis.common.Resource;
import de.datexis.common.WordHelpers;
import de.datexis.index.ArticleRef;
import de.datexis.index.WikiDataArticle;
import de.datexis.index.encoder.EntityEncoder;
import de.datexis.index.impl.LuceneArticleIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorArticleIndex
extends LuceneArticleIndex {
    protected static final Logger log = LoggerFactory.getLogger(VectorArticleIndex.class);
    protected static final int NUM_PARVEC_CANDIDATES = 512;
    protected static final EntityEncoder.Strategy strategy = EntityEncoder.Strategy.NAME_CONTEXT;
    EntityEncoder encoder;

    public VectorArticleIndex(Resource parVec) throws IOException {
        this.encoder = new EntityEncoder(parVec, EntityEncoder.Strategy.NAME);
    }

    @Override
    protected Document createLuceneDocument(WikiDataArticle article) {
        Document doc = super.createLuceneDocument(article);
        INDArray embedding = this.encoder.encodeEntity(article);
        if (embedding != null) {
            this.addVectorField(doc, "vector", embedding);
        } else {
            log.error("Could not encode entity {}", (Object)article.toString());
        }
        return doc;
    }

    public List<ArticleRef> querySimilarArticles(String mention, String context, int hits) {
        ArrayList<ArticleRef> result = new ArrayList<ArticleRef>(hits);
        List<ArticleRef> candidates = this.queryNames(mention, 512);
        INDArray embedding = this.encoder.encodeMention(mention, context);
        for (ArticleRef ref : candidates) {
            INDArray entityEmbedding = ref.getVector();
            if (entityEmbedding != null) {
                INDArray candidate = Nd4j.hstack((INDArray[])new INDArray[]{entityEmbedding, entityEmbedding});
                double score = WordHelpers.cosineSim((INDArray)candidate, (INDArray)embedding);
                if (Double.isFinite(score)) {
                    ref.setScore(score);
                } else {
                    ref.setScore(0.0);
                }
            } else {
                ref.setScore(0.0);
            }
            result.add(ref);
        }
        Collections.sort(result, new ArticleRef.ScoreComparator());
        return result;
    }
}

