/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.index.impl;

import de.datexis.common.Resource;
import de.datexis.preprocess.MinimalLowercasePreprocessor;
import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LuceneIndex {
    protected static final Logger log = LoggerFactory.getLogger(LuceneIndex.class);
    protected IndexReader reader;
    protected IndexSearcher searcher;
    protected Analyzer analyzer;
    protected final NormalizedStringSimilarity sim = new JaroWinkler();
    protected final TokenPreProcess preprocessor = new MinimalLowercasePreprocessor();
    static final FieldType FIELDTYPE_NAME = new FieldType();

    public boolean openIndex(Resource path) throws IOException {
        FSDirectory index = FSDirectory.open((Path)path.getPath());
        return this.openIndex((Directory)index);
    }

    protected boolean openIndex(Directory index) throws IOException {
        this.reader = DirectoryReader.open((Directory)index);
        this.searcher = new IndexSearcher(this.reader);
        this.analyzer = this.buildAnalyzer();
        return true;
    }

    protected abstract Analyzer buildAnalyzer();

    protected String splitString(String name, String suffix) {
        String[] parts = name.split("\\s");
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(part).append(suffix);
        }
        return result.toString();
    }

    protected void addTextField(Document doc, String name, String value, Field.Store store) {
        if (value != null) {
            doc.add((IndexableField)new TextField(name, value, store));
        }
    }

    protected void addStringField(Document doc, String name, String value) {
        if (value != null) {
            doc.add((IndexableField)new StringField(name, value, Field.Store.YES));
        }
    }

    protected void addNameField(Document doc, String name, String value) {
        if (value != null) {
            doc.add((IndexableField)new Field(name, value, FIELDTYPE_NAME));
        }
    }

    static {
        FIELDTYPE_NAME.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        FIELDTYPE_NAME.setTokenized(true);
        FIELDTYPE_NAME.setStored(true);
        FIELDTYPE_NAME.setOmitNorms(true);
        FIELDTYPE_NAME.freeze();
    }
}

