/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.encoder.skipthought;

import de.datexis.encoder.AbstractRESTAdapter;
import de.datexis.encoder.serialization.DeserializationProvider;
import de.datexis.encoder.serialization.JacksonProvider;
import de.datexis.encoder.serialization.SerializationProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipthoughtRESTAdapter
extends AbstractRESTAdapter {
    private static final Logger log = LoggerFactory.getLogger(SkipthoughtRESTAdapter.class);
    public static final int DEFAULT_READ_TIMEOUT = 300000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final long DEFAULT_EMBEDDING_VECTOR_SIZE = 4800L;
    public static final String URL_FORMAT = "http://%s:%d/v2/%s";
    public static final String SENTENCE_ENDPOINT = "embed/sentences";
    public static final String SENTENCES_ENDPOINT = "embed/sentences";
    private String domain;
    private int port;
    private JacksonProvider serdeProvider;

    public SkipthoughtRESTAdapter(String domain, int port, long embeddingVectorSize, int connectTimeout, int readTimeout) {
        super(embeddingVectorSize, connectTimeout, readTimeout);
        this.domain = domain;
        this.port = port;
        this.serdeProvider = new JacksonProvider();
    }

    public SkipthoughtRESTAdapter(String domain, int port) {
        this(domain, port, 4800L, 10000, 300000);
    }

    @Override
    public double[] encodeImpl(String sentence) throws IOException {
        return this.request(sentence, double[].class, this.getUrl("embed/sentences"));
    }

    @Override
    public double[][] encodeImpl(String[] sentencesOfDocument) throws IOException {
        return this.request(sentencesOfDocument, double[][].class, this.getUrl("embed/sentences"));
    }

    @Override
    public double[][][] encodeImpl(String[][] data) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SerializationProvider getSerializationProvider() {
        return this.serdeProvider;
    }

    @Override
    public DeserializationProvider getDeserializationProvider() {
        return this.serdeProvider;
    }

    public URL getUrl(String path) throws MalformedURLException {
        return new URL(String.format(URL_FORMAT, this.domain, this.port, path));
    }
}

