/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.encoder.elmo;

import de.datexis.encoder.AbstractRESTAdapter;
import de.datexis.encoder.elmo.ELMoLayerOutput;
import de.datexis.encoder.serialization.DeserializationProvider;
import de.datexis.encoder.serialization.JacksonProvider;
import de.datexis.encoder.serialization.SerializationProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELMoRESTAdapter
extends AbstractRESTAdapter {
    private static final Logger log = LoggerFactory.getLogger(ELMoRESTAdapter.class);
    public static final int DEFAULT_READ_TIMEOUT = 300000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final long DEFAULT_EMBEDDING_VECTOR_SIZE = 1024L;
    public static final String URL_FORMAT = "http://%s:%d/v2/%s/%s";
    public static final String SENTENCE_ENDPOINT = "embed/sentence";
    public static final String SENTENCES_ENDPOINT = "embed/sentences";
    private ELMoLayerOutput layerOutput;
    private String domain;
    private int port;
    private JacksonProvider serdeProvider;

    public ELMoRESTAdapter(ELMoLayerOutput layerOutput, String domain, int port, long embeddingVectorSize, int connectTimeout, int readTimeout) {
        super(embeddingVectorSize, connectTimeout, readTimeout);
        this.layerOutput = layerOutput;
        this.domain = domain;
        this.port = port;
        this.serdeProvider = new JacksonProvider();
    }

    public ELMoRESTAdapter(ELMoLayerOutput layerOutput, String domain, int port) {
        this(layerOutput, domain, port, 1024L, 10000, 300000);
    }

    @Override
    public double[] encodeImpl(String data) throws IOException {
        log.warn("ELMo can't embed just one Token");
        return this.encodeImpl(new String[]{data})[0];
    }

    @Override
    public double[][] encodeImpl(String[] tokensOfSentence) throws IOException {
        return this.request(tokensOfSentence, double[][].class, this.getUrl(SENTENCES_ENDPOINT));
    }

    @Override
    public double[][][] encodeImpl(String[][] tokensOfDocument2D) throws IOException {
        return this.request(tokensOfDocument2D, double[][][].class, this.getUrl(SENTENCES_ENDPOINT));
    }

    @Override
    public SerializationProvider getSerializationProvider() {
        return this.serdeProvider;
    }

    @Override
    public DeserializationProvider getDeserializationProvider() {
        return this.serdeProvider;
    }

    public URL getUrl(String path) throws MalformedURLException {
        return new URL(String.format(URL_FORMAT, this.domain, this.port, path, this.layerOutput.getPath()));
    }
}

