/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.encoder.impl;

import de.datexis.encoder.impl.AbstractRESTEncoder;
import de.datexis.encoder.impl.RESTAdapter;
import de.datexis.model.Document;
import de.datexis.model.Sentence;
import de.datexis.model.Span;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleRESTEncoder
extends AbstractRESTEncoder {
    private static final Logger log = LoggerFactory.getLogger(SimpleRESTEncoder.class);
    private Class<? extends Span> elementClass;

    public SimpleRESTEncoder(RESTAdapter restAdapter, Class<? extends Span> elementClass) {
        super(restAdapter);
        this.elementClass = elementClass;
    }

    public SimpleRESTEncoder(RESTAdapter restAdapter, String vectorIdentifier, Class<? extends Span> elementClass) {
        super(restAdapter, vectorIdentifier);
        this.elementClass = elementClass;
    }

    public INDArray encode(String word) {
        try {
            return this.encodeImpl(word);
        }
        catch (IOException e) {
            log.error("IO Error while encoding word: {}", (Object)word, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    public abstract INDArray encodeImpl(String var1) throws IOException;

    public INDArray encode(Span span) {
        if (this.elementClass.isInstance(span)) {
            try {
                return this.encodeImpl(span);
            }
            catch (IOException e) {
                log.error("IO Error while encoding span: {}", (Object)span, (Object)e);
                throw new UncheckedIOException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    public abstract INDArray encodeImpl(Span var1) throws IOException;

    public void encodeEach(Sentence input, Class<? extends Span> elementClass) {
        if (elementClass == this.elementClass) {
            try {
                this.encodeEachImpl(input);
            }
            catch (IOException e) {
                log.error("IO Error while encoding sentence: {}", (Object)input, (Object)e);
                throw new UncheckedIOException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public abstract void encodeEachImpl(Sentence var1) throws IOException;

    public void encodeEach(Document input, Class<? extends Span> elementClass) {
        if (elementClass == this.elementClass) {
            try {
                this.encodeEachImpl(input);
            }
            catch (IOException e) {
                log.error("IO Error while encoding document: {}", (Object)input.getTitle(), (Object)e);
                throw new UncheckedIOException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public abstract void encodeEachImpl(Document var1) throws IOException;

    public void encodeEach(Collection<Document> docs, Class<? extends Span> elementClass) {
        if (elementClass == this.elementClass) {
            try {
                this.encodeEachImpl(docs);
            }
            catch (IOException e) {
                log.error("IO Error while encoding documents", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public abstract void encodeEachImpl(Collection<Document> var1) throws IOException;
}

