/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.encoder.impl;

import de.datexis.encoder.impl.RESTAdapter;
import de.datexis.encoder.impl.SectorRESTAdapter;
import de.datexis.encoder.impl.SimpleRESTEncoder;
import de.datexis.model.Document;
import de.datexis.model.Sentence;
import de.datexis.model.Span;
import java.io.IOException;
import java.util.Collection;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectorRESTEncoder
extends SimpleRESTEncoder {
    private static final Logger log = LoggerFactory.getLogger(SectorRESTEncoder.class);

    public static SectorRESTEncoder create(String domain, int port) {
        return new SectorRESTEncoder(new SectorRESTAdapter(domain, port));
    }

    public static SectorRESTEncoder create(String domain, int port, String vectorIdentifier) {
        return new SectorRESTEncoder((RESTAdapter)new SectorRESTAdapter(domain, port), vectorIdentifier);
    }

    public static SectorRESTEncoder create(String domain, int port, long embeddingVectorSize, int connectTimeout, int readTimeout) {
        return new SectorRESTEncoder(new SectorRESTAdapter(domain, port, embeddingVectorSize, connectTimeout, readTimeout));
    }

    public static SectorRESTEncoder create(String domain, int port, long embeddingVectorSize, int connectTimeout, int readTimeout, String vectorIdentifier) {
        return new SectorRESTEncoder((RESTAdapter)new SectorRESTAdapter(domain, port, embeddingVectorSize, connectTimeout, readTimeout), vectorIdentifier);
    }

    public SectorRESTEncoder(RESTAdapter restAdapter) {
        super(restAdapter, Sentence.class);
    }

    public SectorRESTEncoder(RESTAdapter restAdapter, String vectorIdentifier) {
        super(restAdapter, vectorIdentifier, Sentence.class);
    }

    @Override
    public INDArray encodeImpl(String word) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray encodeImpl(Span span) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encodeEachImpl(Sentence input) throws IOException {
        this.encodeEach(input, Sentence::toTokenizedString);
    }

    @Override
    public void encodeEachImpl(Document input) throws IOException {
        this.encodeEach1D(input.getSentences(), Sentence::toTokenizedString);
    }

    @Override
    public void encodeEachImpl(Collection<Document> docs) throws IOException {
        for (Document document : docs) {
            this.encodeEachImpl(document);
        }
    }
}

