/*
 * Decompiled with CFR 0.152.
 */
package de.datexis.encoder.impl;

import de.datexis.encoder.impl.RESTAdapter;
import de.datexis.encoder.impl.serde.DeserializationProvider;
import de.datexis.encoder.impl.serde.SerializationProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRESTAdapter
implements RESTAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractRESTAdapter.class);
    public static final String HTTP_REQUEST_METHOD = "POST";
    public static final String HTTP_CONTENT_TYPE_NAME = "Content-Type";
    public static final String HTTP_ACCEPT_TYPE_NAME = "Accept";
    private long embeddingVectorSize;
    private int connectTimeout;
    private int readTimeout;

    public AbstractRESTAdapter(long embeddingVectorSize, int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.embeddingVectorSize = embeddingVectorSize;
    }

    @Override
    public long getEmbeddingVectorSize() {
        return this.embeddingVectorSize;
    }

    @Override
    public double[] encode(String data) throws IOException {
        try {
            return this.encodeImpl(data);
        }
        catch (IOException e) {
            log.error("IO error while encoding: {}", (Object)data, (Object)e);
            throw e;
        }
    }

    public abstract double[] encodeImpl(String var1) throws IOException;

    @Override
    public double[][] encode(String[] data) throws IOException {
        try {
            return this.encodeImpl(data);
        }
        catch (IOException e) {
            log.error("IO error while encoding: {}", (Object)data, (Object)e);
            throw e;
        }
    }

    public abstract double[][] encodeImpl(String[] var1) throws IOException;

    @Override
    public double[][][] encode(String[][] data) throws IOException {
        try {
            return this.encodeImpl(data);
        }
        catch (IOException e) {
            log.error("IO error while encoding: {}", (Object)data, (Object)e);
            throw e;
        }
    }

    public abstract double[][][] encodeImpl(String[][] var1) throws IOException;

    public <I, O> O request(I input, Class<O> classOfO, URL url) throws IOException {
        log.debug("building request");
        HttpURLConnection httpConnection = this.configureConnection(url);
        log.debug("connect to: {}", (Object)httpConnection.getURL());
        httpConnection.connect();
        log.debug("writing to: {}", (Object)httpConnection.getURL());
        this.getSerializationProvider().serialize(input, httpConnection.getOutputStream());
        log.debug("reading from: {}", (Object)httpConnection.getURL());
        O output = this.getDeserializationProvider().deserialize(httpConnection.getInputStream(), classOfO);
        log.debug("response read from: {}", (Object)httpConnection.getURL());
        httpConnection.disconnect();
        log.debug("disconnected from: {}", (Object)httpConnection.getURL());
        return output;
    }

    public HttpURLConnection configureConnection(URL url) throws IOException {
        HttpURLConnection httpConnection = this.getConnection(url);
        httpConnection.setRequestMethod(HTTP_REQUEST_METHOD);
        httpConnection.setRequestProperty(HTTP_CONTENT_TYPE_NAME, this.getSerializationProvider().getContentType());
        httpConnection.setRequestProperty(HTTP_ACCEPT_TYPE_NAME, this.getDeserializationProvider().getAcceptType());
        httpConnection.setConnectTimeout(this.connectTimeout);
        httpConnection.setReadTimeout(this.readTimeout);
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        return httpConnection;
    }

    public abstract SerializationProvider getSerializationProvider();

    public abstract DeserializationProvider getDeserializationProvider();

    public HttpURLConnection getConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }
}

