/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.injector;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import de.darkatra.injector.InjectionException;
import de.darkatra.injector.ModuleUtils;
import de.darkatra.injector.ProcessArchitecture;
import de.darkatra.injector.jna.Psapi;
import de.darkatra.injector.logging.Logger;
import de.darkatra.injector.logging.NoopLogger;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J=\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00180\u001b\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010 \u001a\u00020\nH\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/darkatra/injector/ProcessUtils;", "", "<init>", "()V", "IMAGE_FILE_MACHINE_I386", "", "IMAGE_FILE_MACHINE_AMD64", "openHandleToProcess", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "processId", "", "getRemoteModuleHandle", "Lcom/sun/jna/platform/win32/WinDef$HMODULE;", "processHandle", "name", "", "logger", "Lde/darkatra/injector/logging/Logger;", "readInt", "", "address", "Lcom/sun/jna/Pointer;", "readShort", "readProcessMemory", "T", "bytesToRead", "mappingFunction", "Lkotlin/Function1;", "Lcom/sun/jna/Memory;", "(Lcom/sun/jna/platform/win32/WinNT$HANDLE;Lcom/sun/jna/Pointer;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getProcessArchitecture", "Lde/darkatra/injector/ProcessArchitecture;", "moduleBaseAddress", "getProcessArchitecture$kotlin_dll_injector_common", "kotlin-dll-injector-common"})
@SourceDebugExtension(value={"SMAP\nProcessUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessUtils.kt\nde/darkatra/injector/ProcessUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n295#2,2:145\n*S KotlinDebug\n*F\n+ 1 ProcessUtils.kt\nde/darkatra/injector/ProcessUtils\n*L\n62#1:145,2\n*E\n"})
public final class ProcessUtils {
    @NotNull
    public static final ProcessUtils INSTANCE = new ProcessUtils();
    private static final short IMAGE_FILE_MACHINE_I386 = (short)332;
    private static final short IMAGE_FILE_MACHINE_AMD64 = (short)34404;

    private ProcessUtils() {
    }

    @Nullable
    public final WinNT.HANDLE openHandleToProcess(long processId) {
        return Kernel32.INSTANCE.OpenProcess(1082, false, Math.toIntExact(processId));
    }

    @Nullable
    public final WinDef.HMODULE getRemoteModuleHandle(@NotNull WinNT.HANDLE processHandle, @NotNull String name, @NotNull Logger logger) {
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter((Object)processHandle, (String)"processHandle");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Object[] modules = new WinDef.HMODULE[1024];
            IntByReference modulesSizeNeeded = new IntByReference();
            boolean successful = Psapi.Companion.getINSTANCE().EnumProcessModulesEx(processHandle, (WinDef.HMODULE[])modules, modules.length, modulesSizeNeeded, 3);
            if (!successful) {
                throw new InjectionException("Failed to enumerate process modules, error code: " + Kernel32.INSTANCE.GetLastError());
            }
            if (modulesSizeNeeded.getValue() > modules.length) {
                Logger.warn$default(logger, "Only iterating the first " + modules.length + " modules but this process has " + modulesSizeNeeded.getValue() + " modules.", null, 2, null);
            }
            Iterable $this$firstOrNull$iv = ArraysKt.filterNotNull((Object[])modules);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block5: {
                    String string;
                    WinDef.HMODULE module = (WinDef.HMODULE)element$iv;
                    boolean bl2 = false;
                    try {
                        string = ModuleUtils.INSTANCE.getModuleName$kotlin_dll_injector_common(processHandle, module);
                    }
                    catch (InjectionException e) {
                        Logger.warn$default(logger, "Error finding module by name: " + e.getMessage(), null, 2, null);
                        bl = false;
                        break block5;
                    }
                    String moduleName = string;
                    bl = StringsKt.equals((String)moduleName, (String)name, (boolean)true);
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        return v1;
    }

    public static /* synthetic */ WinDef.HMODULE getRemoteModuleHandle$default(ProcessUtils processUtils, WinNT.HANDLE hANDLE, String string, Logger logger, int n, Object object) {
        if ((n & 4) != 0) {
            logger = new NoopLogger();
        }
        return processUtils.getRemoteModuleHandle(hANDLE, string, logger);
    }

    public final int readInt(@NotNull WinNT.HANDLE processHandle, @NotNull Pointer address) {
        Intrinsics.checkNotNullParameter((Object)processHandle, (String)"processHandle");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return ((Number)this.readProcessMemory(processHandle, address, 4, ProcessUtils::readInt$lambda$0)).intValue();
    }

    public final short readShort(@NotNull WinNT.HANDLE processHandle, @NotNull Pointer address) {
        Intrinsics.checkNotNullParameter((Object)processHandle, (String)"processHandle");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return ((Number)this.readProcessMemory(processHandle, address, 2, ProcessUtils::readShort$lambda$0)).shortValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readProcessMemory(@NotNull WinNT.HANDLE processHandle, @NotNull Pointer address, int bytesToRead, @NotNull Function1<? super Memory, ? extends T> mappingFunction) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)processHandle, (String)"processHandle");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        Closeable closeable = (Closeable)new Memory((long)bytesToRead);
        Throwable throwable = null;
        try {
            Memory memory = (Memory)closeable;
            boolean bl = false;
            boolean success = Kernel32.INSTANCE.ReadProcessMemory(processHandle, address, (Pointer)memory, bytesToRead, null);
            if (!success) {
                throw new RuntimeException("Failed to read process memory, error code: " + Kernel32.INSTANCE.GetLastError());
            }
            object = mappingFunction.invoke((Object)memory);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    @NotNull
    public final ProcessArchitecture getProcessArchitecture$kotlin_dll_injector_common(@NotNull WinNT.HANDLE processHandle, long moduleBaseAddress) {
        ProcessArchitecture processArchitecture;
        short imageFileMachine;
        Intrinsics.checkNotNullParameter((Object)processHandle, (String)"processHandle");
        Pointer pointer = Pointer.createConstant((long)(moduleBaseAddress + (long)60));
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"createConstant(...)");
        int offsetToPESignature = this.readInt(processHandle, pointer);
        Pointer pointer2 = Pointer.createConstant((long)(moduleBaseAddress + (long)offsetToPESignature + (long)4));
        Intrinsics.checkNotNullExpressionValue((Object)pointer2, (String)"createConstant(...)");
        short s = imageFileMachine = this.readShort(processHandle, pointer2);
        if (s == IMAGE_FILE_MACHINE_I386) {
            processArchitecture = ProcessArchitecture.X_86;
        } else if (s == IMAGE_FILE_MACHINE_AMD64) {
            processArchitecture = ProcessArchitecture.X_64;
        } else {
            throw new InjectionException("Unsupported image file machine: " + imageFileMachine);
        }
        return processArchitecture;
    }

    private static final int readInt$lambda$0(Memory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getInt(0L);
    }

    private static final short readShort$lambda$0(Memory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getShort(0L);
    }
}

