/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.feign.sdkv2;

import de.darkatra.feign.common.AwsSignatureV4Constants;
import de.darkatra.feign.sdkv2.AwsSignatureV4RequestInterceptor;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.regions.Region;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J4\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00120\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/darkatra/feign/sdkv2/AwsSignatureV4RequestInterceptor;", "Lfeign/RequestInterceptor;", "awsCredentialsProvider", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;", "service", "", "region", "Lsoftware/amazon/awssdk/regions/Region;", "<init>", "(Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;Ljava/lang/String;Lsoftware/amazon/awssdk/regions/Region;)V", "aws4Signer", "Lsoftware/amazon/awssdk/http/auth/aws/signer/AwsV4HttpSigner;", "apply", "", "template", "Lfeign/RequestTemplate;", "convertHeaders", "", "", "headers", "", "getRequestUri", "Ljava/net/URI;", "feign-aws-sigv4-sdkv2"})
public final class AwsSignatureV4RequestInterceptor
implements RequestInterceptor {
    @NotNull
    private final AwsCredentialsProvider awsCredentialsProvider;
    @NotNull
    private final String service;
    @NotNull
    private final Region region;
    @NotNull
    private final AwsV4HttpSigner aws4Signer;

    public AwsSignatureV4RequestInterceptor(@NotNull AwsCredentialsProvider awsCredentialsProvider, @NotNull String service, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)awsCredentialsProvider, (String)"awsCredentialsProvider");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.service = service;
        this.region = region;
        AwsV4HttpSigner awsV4HttpSigner = AwsV4HttpSigner.create();
        Intrinsics.checkNotNullExpressionValue((Object)awsV4HttpSigner, (String)"create(...)");
        this.aws4Signer = awsV4HttpSigner;
    }

    public void apply(@NotNull RequestTemplate template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        byte[] body = template.body();
        SdkHttpRequest signedRequest = this.aws4Signer.sign(arg_0 -> AwsSignatureV4RequestInterceptor.apply$lambda$0(this, template, body, arg_0)).request();
        signedRequest.headers().entrySet().stream().filter(arg_0 -> AwsSignatureV4RequestInterceptor.apply$lambda$2(AwsSignatureV4RequestInterceptor::apply$lambda$1, arg_0)).forEach(arg_0 -> AwsSignatureV4RequestInterceptor.apply$lambda$4(arg_0 -> AwsSignatureV4RequestInterceptor.apply$lambda$3(template, arg_0), arg_0));
    }

    private final Map<String, List<String>> convertHeaders(Map<String, ? extends Collection<String>> headers) {
        Map<String, List<String>> map = headers.entrySet().stream().map(arg_0 -> AwsSignatureV4RequestInterceptor.convertHeaders$lambda$6(AwsSignatureV4RequestInterceptor::convertHeaders$lambda$5, arg_0)).collect(Collectors.toMap(arg_0 -> AwsSignatureV4RequestInterceptor.convertHeaders$lambda$7((Function1)convertHeaders.2.INSTANCE, arg_0), arg_0 -> AwsSignatureV4RequestInterceptor.convertHeaders$lambda$8((Function1)convertHeaders.3.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue(map, (String)"collect(...)");
        return map;
    }

    private final URI getRequestUri(RequestTemplate template) {
        String url = template.feignTarget().url();
        String pathWithParams = template.url();
        Intrinsics.checkNotNull((Object)url);
        URI uRI = URI.create(StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null) ? url : url + '/');
        Intrinsics.checkNotNull((Object)pathWithParams);
        URI uRI2 = uRI.resolve(StringsKt.startsWith$default((String)pathWithParams, (String)"/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)pathWithParams, (CharSequence)"/") : pathWithParams);
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"resolve(...)");
        return uRI2;
    }

    private static final void apply$lambda$0(AwsSignatureV4RequestInterceptor this$0, RequestTemplate $template, byte[] $body, SignRequest.Builder request) {
        SignRequest.Builder builder = (SignRequest.Builder)request.identity((Identity)this$0.awsCredentialsProvider.resolveCredentials());
        SdkHttpFullRequest.Builder builder2 = SdkHttpFullRequest.builder().uri(this$0.getRequestUri($template)).method(SdkHttpMethod.fromValue((String)$template.method()));
        Map map = $template.headers();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"headers(...)");
        ((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)builder.request((SdkHttpRequest)builder2.headers(this$0.convertHeaders(map)).build())).payload((Object)($body != null ? RequestBody.fromBytes((byte[])$body).contentStreamProvider() : RequestBody.empty().contentStreamProvider()))).putProperty(AwsV4FamilyHttpSigner.SERVICE_SIGNING_NAME, (Object)this$0.service)).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this$0.region.id());
    }

    private static final boolean apply$lambda$1(Map.Entry header) {
        return AwsSignatureV4Constants.INSTANCE.getHEADERS_TO_COPY().contains(header.getKey());
    }

    private static final boolean apply$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit apply$lambda$3(RequestTemplate $template, Map.Entry header) {
        $template.header((String)header.getKey(), (Iterable)header.getValue());
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Pair convertHeaders$lambda$5(Map.Entry header) {
        return TuplesKt.to(header.getKey(), (Object)CollectionsKt.toList((Iterable)((Iterable)header.getValue())));
    }

    private static final Pair convertHeaders$lambda$6(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    private static final String convertHeaders$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final List convertHeaders$lambda$8(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

