/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.feign.sdkv2;

import de.darkatra.feign.sdkv2.AwsSignatureV4RequestInterceptor;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J4\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110\u00102\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/darkatra/feign/sdkv2/AwsSignatureV4RequestInterceptor;", "Lfeign/RequestInterceptor;", "awsCredentialsProvider", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;", "service", "", "region", "Lsoftware/amazon/awssdk/regions/Region;", "(Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;Ljava/lang/String;Lsoftware/amazon/awssdk/regions/Region;)V", "aws4Signer", "Lsoftware/amazon/awssdk/auth/signer/Aws4Signer;", "apply", "", "template", "Lfeign/RequestTemplate;", "convertHeaders", "", "", "headers", "", "getRequestUri", "Ljava/net/URI;", "feign-aws-sigv4-sdkv2"})
public final class AwsSignatureV4RequestInterceptor
implements RequestInterceptor {
    @NotNull
    private final AwsCredentialsProvider awsCredentialsProvider;
    @NotNull
    private final String service;
    @NotNull
    private final Region region;
    @NotNull
    private final Aws4Signer aws4Signer;

    public AwsSignatureV4RequestInterceptor(@NotNull AwsCredentialsProvider awsCredentialsProvider, @NotNull String service, @NotNull Region region) {
        Intrinsics.checkNotNullParameter((Object)awsCredentialsProvider, (String)"awsCredentialsProvider");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.service = service;
        this.region = region;
        Aws4Signer aws4Signer = Aws4Signer.create();
        Intrinsics.checkNotNullExpressionValue((Object)aws4Signer, (String)"create(...)");
        this.aws4Signer = aws4Signer;
    }

    public void apply(@NotNull RequestTemplate template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        byte[] body = template.body();
        SdkHttpFullRequest.Builder builder = SdkHttpFullRequest.builder().uri(this.getRequestUri(template)).method(SdkHttpMethod.fromValue((String)template.method()));
        Map map = template.headers();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"headers(...)");
        SdkHttpFullRequest signedRequest = this.aws4Signer.sign(builder.headers(this.convertHeaders(map)).contentStreamProvider(body != null ? RequestBody.fromBytes((byte[])body).contentStreamProvider() : RequestBody.empty().contentStreamProvider()).build(), Aws4SignerParams.builder().awsCredentials(this.awsCredentialsProvider.resolveCredentials()).signingRegion(this.region).signingName(this.service).build());
        signedRequest.headers().entrySet().stream().filter(arg_0 -> AwsSignatureV4RequestInterceptor.apply$lambda$0(apply.1.INSTANCE, arg_0)).forEach(arg_0 -> AwsSignatureV4RequestInterceptor.apply$lambda$1((Function1)new Function1<Map.Entry<String, List<String>>, Unit>(template){
            final /* synthetic */ RequestTemplate $template;
            {
                this.$template = $template;
                super(1);
            }

            public final void invoke(Map.Entry<String, List<String>> header) {
                this.$template.header(header.getKey(), (Iterable)header.getValue());
            }
        }, arg_0));
    }

    private final Map<String, List<String>> convertHeaders(Map<String, ? extends Collection<String>> headers) {
        Map<String, List<String>> map = headers.entrySet().stream().map(arg_0 -> AwsSignatureV4RequestInterceptor.convertHeaders$lambda$2(convertHeaders.1.INSTANCE, arg_0)).collect(Collectors.toMap(arg_0 -> AwsSignatureV4RequestInterceptor.convertHeaders$lambda$3((Function1)convertHeaders.2.INSTANCE, arg_0), arg_0 -> AwsSignatureV4RequestInterceptor.convertHeaders$lambda$4((Function1)convertHeaders.3.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue(map, (String)"collect(...)");
        return map;
    }

    private final URI getRequestUri(RequestTemplate template) {
        String url = template.feignTarget().url();
        String pathWithParams = template.url();
        Intrinsics.checkNotNull((Object)url);
        URI uRI = URI.create(StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null) ? url : url + '/');
        Intrinsics.checkNotNull((Object)pathWithParams);
        URI uRI2 = uRI.resolve(StringsKt.startsWith$default((String)pathWithParams, (String)"/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)pathWithParams, (CharSequence)"/") : pathWithParams);
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"resolve(...)");
        return uRI2;
    }

    private static final boolean apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Pair convertHeaders$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final String convertHeaders$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final List convertHeaders$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

