/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.ParameterName;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0086\u0001\u00126\u0010\u0003\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0004\u0012!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00028\u00000\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u001aR>\u0010\u0003\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/darkatra/bfme2/map/serialization/SimpleSerde;", "T", "Lde/darkatra/bfme2/map/serialization/Serde;", "serializationFunction", "Lkotlin/Function2;", "Ljava/io/OutputStream;", "Lkotlin/ParameterName;", "name", "outputStream", "data", "", "deserializationFunction", "Lkotlin/Function1;", "Lcom/google/common/io/CountingInputStream;", "inputStream", "context", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "<init>", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;)V", "serialize", "(Ljava/io/OutputStream;Ljava/lang/Object;)V", "deserialize", "(Lcom/google/common/io/CountingInputStream;)Ljava/lang/Object;", "map"})
public abstract class SimpleSerde<T>
implements Serde<T> {
    @NotNull
    private final Function2<@ParameterName(name="outputStream") OutputStream, @ParameterName(name="data") T, Unit> serializationFunction;
    @NotNull
    private final Function1<@ParameterName(name="inputStream") CountingInputStream, T> deserializationFunction;
    @NotNull
    private final SerializationContext context;
    @NotNull
    private final PreProcessor<T> preProcessor;
    @NotNull
    private final PostProcessor<T> postProcessor;

    public SimpleSerde(@NotNull Function2<? super @ParameterName(name="outputStream") OutputStream, ? super @ParameterName(name="data") T, Unit> serializationFunction, @NotNull Function1<? super @ParameterName(name="inputStream") CountingInputStream, ? extends T> deserializationFunction, @NotNull SerializationContext context, @NotNull PreProcessor<T> preProcessor, @NotNull PostProcessor<T> postProcessor) {
        Intrinsics.checkNotNullParameter(serializationFunction, (String)"serializationFunction");
        Intrinsics.checkNotNullParameter(deserializationFunction, (String)"deserializationFunction");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        this.serializationFunction = serializationFunction;
        this.deserializationFunction = deserializationFunction;
        this.context = context;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, T data) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.serializationFunction.invoke((Object)outputStream, this.preProcessor.preProcess(data, this.context));
    }

    @Override
    public T deserialize(@NotNull CountingInputStream inputStream) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Object it = object = this.deserializationFunction.invoke((Object)inputStream);
        boolean bl = false;
        this.postProcessor.postProcess(it, this.context);
        return (T)object;
    }
}

