/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.InvalidDataException;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.DataSection;
import de.darkatra.bfme2.map.serialization.model.DataSectionLeaf;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/darkatra/bfme2/map/serialization/FourByteStringSerde;", "Lde/darkatra/bfme2/map/serialization/Serde;", "", "context", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "<init>", "(Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;)V", "calculateDataSection", "Lde/darkatra/bfme2/map/serialization/model/DataSection;", "data", "serialize", "", "outputStream", "Ljava/io/OutputStream;", "deserialize", "inputStream", "Lcom/google/common/io/CountingInputStream;", "map"})
public final class FourByteStringSerde
implements Serde<String> {
    @NotNull
    private final SerializationContext context;
    @NotNull
    private final PreProcessor<String> preProcessor;
    @NotNull
    private final PostProcessor<String> postProcessor;

    public FourByteStringSerde(@NotNull SerializationContext context, @NotNull PreProcessor<String> preProcessor, @NotNull PostProcessor<String> postProcessor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        this.context = context;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
    }

    @Override
    @NotNull
    public DataSection calculateDataSection(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new DataSectionLeaf(4L);
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String it = this.preProcessor.preProcess(data, this.context);
        boolean bl = false;
        if (it.length() != 4) {
            throw new InvalidDataException("Expected '" + it + "' to have a length of exactly four characters.", null, 2, null);
        }
        String string = it;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        outputStream.write(byArray);
    }

    @Override
    @NotNull
    public String deserialize(@NotNull CountingInputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        byte[] byArray = inputStream.readNBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        Object object = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        Object it = object = (Object)new String((byte[])object, charset2);
        boolean bl = false;
        this.postProcessor.postProcess((String)it, this.context);
        return object;
    }
}

