/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.ConversionException;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.DataSection;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BG\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010$R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0018\u0010\u0013\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/darkatra/bfme2/map/serialization/EnumSerde;", "T", "", "Lde/darkatra/bfme2/map/serialization/Serde;", "classOfT", "Lkotlin/reflect/KClass;", "context", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "serde", "", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "<init>", "(Lkotlin/reflect/KClass;Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/Serde;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;)V", "enumValues", "", "[Ljava/lang/Enum;", "enumValueGetter", "Lkotlin/reflect/KProperty1$Getter;", "calculateDataSection", "Lde/darkatra/bfme2/map/serialization/model/DataSection;", "data", "(Ljava/lang/Enum;)Lde/darkatra/bfme2/map/serialization/model/DataSection;", "serialize", "", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;Ljava/lang/Enum;)V", "deserialize", "inputStream", "Lcom/google/common/io/CountingInputStream;", "(Lcom/google/common/io/CountingInputStream;)Ljava/lang/Enum;", "getEnumValue", "value", "(Ljava/lang/Object;)Ljava/lang/Enum;", "map"})
@SourceDebugExtension(value={"SMAP\nEnumSerde.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumSerde.kt\nde/darkatra/bfme2/map/serialization/EnumSerde\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,64:1\n1400#2,2:65\n*S KotlinDebug\n*F\n+ 1 EnumSerde.kt\nde/darkatra/bfme2/map/serialization/EnumSerde\n*L\n55#1:65,2\n*E\n"})
public final class EnumSerde<T extends Enum<?>>
implements Serde<T> {
    @NotNull
    private final KClass<T> classOfT;
    @NotNull
    private final SerializationContext context;
    @NotNull
    private final Serde<Object> serde;
    @NotNull
    private final PreProcessor<T> preProcessor;
    @NotNull
    private final PostProcessor<T> postProcessor;
    @NotNull
    private final T[] enumValues;
    @NotNull
    private final KProperty1.Getter<T, ?> enumValueGetter;

    public EnumSerde(@NotNull KClass<T> classOfT, @NotNull SerializationContext context, @NotNull Serde<Object> serde, @NotNull PreProcessor<T> preProcessor, @NotNull PostProcessor<T> postProcessor) {
        Intrinsics.checkNotNullParameter(classOfT, (String)"classOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(serde, (String)"serde");
        Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        this.classOfT = classOfT;
        this.context = context;
        this.serde = serde;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        KProperty1 kProperty1 = (KProperty1)CollectionsKt.firstOrNull((Iterable)KClasses.getMemberProperties(this.classOfT));
        if (kProperty1 == null) {
            throw new IllegalStateException(("Expected '" + this.classOfT.getSimpleName() + "' to have a primary constructor with exactly one parameter.").toString());
        }
        KProperty1 firstConstructorParameter = kProperty1;
        T[] TArray = JvmClassMappingKt.getJavaClass(this.classOfT).getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"getEnumConstants(...)");
        this.enumValues = (Enum[])TArray;
        this.enumValueGetter = firstConstructorParameter.getGetter();
        if (this.enumValueGetter.getVisibility() != KVisibility.INTERNAL && this.enumValueGetter.getVisibility() != KVisibility.PUBLIC) {
            throw new IllegalStateException(("Expected '" + this.classOfT.getSimpleName() + "#" + this.enumValueGetter.getName() + "' to be accessible.").toString());
        }
    }

    @Override
    @NotNull
    public DataSection calculateDataSection(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object[] objectArray = new Object[]{data};
        Object object = this.enumValueGetter.call(objectArray);
        Intrinsics.checkNotNull((Object)object);
        return this.serde.calculateDataSection(object);
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, @NotNull T data) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object[] objectArray = new Object[]{this.preProcessor.preProcess(data, this.context)};
        Object object = this.enumValueGetter.call(objectArray);
        Intrinsics.checkNotNull((Object)object);
        this.serde.serialize(outputStream, object);
    }

    @Override
    @NotNull
    public T deserialize(@NotNull CountingInputStream inputStream) {
        T t;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        T it = t = this.getEnumValue(this.serde.deserialize(inputStream));
        boolean bl = false;
        this.postProcessor.postProcess(it, this.context);
        return t;
    }

    private final T getEnumValue(Object value) {
        T t;
        block2: {
            T[] $this$firstOrNull$iv = this.enumValues;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                T element$iv;
                T enumValue = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                Object[] objectArray = new Object[]{enumValue};
                Object deserializationEnumValue = this.enumValueGetter.call(objectArray);
                if (!(value instanceof String && deserializationEnumValue instanceof String ? StringsKt.equals((String)((String)value), (String)((String)deserializationEnumValue), (boolean)true) : Intrinsics.areEqual((Object)value, (Object)deserializationEnumValue))) continue;
                t = element$iv;
                break block2;
            }
            t = null;
        }
        if (t == null) {
            throw new ConversionException("Could not deserialize " + this.classOfT.getSimpleName() + " from '" + value + "' (" + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + ")");
        }
        return t;
    }
}

