/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.InvalidDataException;
import de.darkatra.bfme2.map.Asset;
import de.darkatra.bfme2.map.serialization.AnnotationProcessingContext;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerdeFactory;
import de.darkatra.bfme2.map.serialization.SerdeProperties;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.UseSerdeProperties;
import de.darkatra.bfme2.map.serialization.model.DataSection;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.MustBeDocumented;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@UseSerdeProperties(propertiesClass=Properties.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/darkatra/bfme2/map/serialization/ConditionalSerde;", "Lde/darkatra/bfme2/map/serialization/Serde;", "", "serdeFactory", "Lde/darkatra/bfme2/map/serialization/SerdeFactory;", "annotationProcessingContext", "Lde/darkatra/bfme2/map/serialization/AnnotationProcessingContext;", "serializationContext", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "assetTypes", "", "Lkotlin/reflect/KClass;", "<init>", "(Lde/darkatra/bfme2/map/serialization/SerdeFactory;Lde/darkatra/bfme2/map/serialization/AnnotationProcessingContext;Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;Ljava/util/List;)V", "currentElementName", "", "serdes", "", "calculateDataSection", "Lde/darkatra/bfme2/map/serialization/model/DataSection;", "data", "serialize", "", "outputStream", "Ljava/io/OutputStream;", "deserialize", "inputStream", "Lcom/google/common/io/CountingInputStream;", "Properties", "map"})
@SourceDebugExtension(value={"SMAP\nConditionalSerde.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConditionalSerde.kt\nde/darkatra/bfme2/map/serialization/ConditionalSerde\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,68:1\n1193#2,2:69\n1267#2,2:71\n295#2,2:74\n1270#2:76\n295#2,2:78\n295#2,2:81\n20#3:73\n20#3:77\n20#3:80\n*S KotlinDebug\n*F\n+ 1 ConditionalSerde.kt\nde/darkatra/bfme2/map/serialization/ConditionalSerde\n*L\n35#1:69,2\n35#1:71,2\n36#1:74,2\n35#1:76\n42#1:78,2\n50#1:81,2\n36#1:73\n42#1:77\n50#1:80\n*E\n"})
public final class ConditionalSerde
implements Serde<Object> {
    @NotNull
    private final SerializationContext serializationContext;
    @NotNull
    private final PreProcessor<Object> preProcessor;
    @NotNull
    private final PostProcessor<Object> postProcessor;
    @NotNull
    private final String currentElementName;
    @NotNull
    private final Map<String, Serde<Object>> serdes;

    /*
     * WARNING - void declaration
     */
    public ConditionalSerde(@NotNull SerdeFactory serdeFactory, @NotNull AnnotationProcessingContext annotationProcessingContext, @NotNull SerializationContext serializationContext, @NotNull PreProcessor<Object> preProcessor, @NotNull PostProcessor<Object> postProcessor, @NotNull List<? extends KClass<Object>> assetTypes) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)serdeFactory, (String)"serdeFactory");
        Intrinsics.checkNotNullParameter((Object)annotationProcessingContext, (String)"annotationProcessingContext");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        Intrinsics.checkNotNullParameter(assetTypes, (String)"assetTypes");
        this.serializationContext = serializationContext;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.currentElementName = annotationProcessingContext.getCurrentElement$map().getName();
        Iterable iterable = assetTypes;
        ConditionalSerde conditionalSerde = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var10_11 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Asset assetName;
            Object v0;
            KClass assetType;
            Map map;
            block3: {
                map = destination$iv$iv;
                assetType = (KClass)element$iv$iv;
                boolean bl = false;
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)assetType;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv2 : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(it$iv instanceof Asset)) continue;
                    v0 = element$iv$iv2;
                    break block3;
                }
                v0 = null;
            }
            if ((Asset)((Annotation)v0) == null) {
                throw new IllegalStateException((Reflection.getOrCreateKotlinClass(ConditionalSerde.class).getSimpleName() + " only supports classes that are annotated with '" + Reflection.getOrCreateKotlinClass(Asset.class).getSimpleName() + "'. Found none on '" + assetType.getSimpleName() + "'.").toString());
            }
            Pair pair = new Pair((Object)assetName.name(), serdeFactory.getSerde$map(assetType));
            map.put(pair.getFirst(), pair.getSecond());
        }
        conditionalSerde.serdes = destination$iv$iv;
    }

    @Override
    @NotNull
    public DataSection calculateDataSection(@NotNull Object data) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(data.getClass());
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof Asset)) continue;
                v0 = element$iv$iv;
                break block3;
            }
            v0 = null;
        }
        Asset asset = (Asset)((Annotation)v0);
        if (asset == null) {
            throw new IllegalStateException("Could not find asset annotation for " + this.currentElementName + ". Expected one of: " + this.serdes.keySet());
        }
        Asset asset2 = asset;
        Serde<Object> serde = this.serdes.get(asset2.name());
        if (serde == null) {
            throw new IllegalStateException("Could not find serde for '" + asset2.name() + "' calculating byte count for " + this.currentElementName + ". Expected one of: " + this.serdes.keySet());
        }
        Serde<Object> serde2 = serde;
        return serde2.calculateDataSection(data);
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, @NotNull Object data) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(data.getClass());
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof Asset)) continue;
                v0 = element$iv$iv;
                break block3;
            }
            v0 = null;
        }
        Asset asset = (Asset)((Annotation)v0);
        if (asset == null) {
            throw new IllegalStateException("Could not find asset annotation for " + this.currentElementName + ". Expected one of: " + this.serdes.keySet());
        }
        Asset asset2 = asset;
        Serde<Object> serde = this.serdes.get(asset2.name());
        if (serde == null) {
            throw new IllegalStateException("Could not find serde for '" + asset2.name() + "' writing " + this.currentElementName + ". Expected one of: " + this.serdes.keySet());
        }
        Serde<Object> serde2 = serde;
        Object it = this.preProcessor.preProcess(data, this.serializationContext);
        boolean bl = false;
        serde2.serialize(outputStream, it);
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull CountingInputStream inputStream) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        String assetName = this.serializationContext.peek$map().getAssetName$map();
        Serde<Object> serde = this.serdes.get(assetName);
        if (serde == null) {
            throw new InvalidDataException("Unexpected assetName '" + assetName + "' reading " + this.currentElementName + ". Expected one of: " + this.serdes.keySet(), null, 2, null);
        }
        Serde<Object> serde2 = serde;
        Object it = t = serde2.deserialize(inputStream);
        boolean bl = false;
        this.postProcessor.postProcess(it, this.serializationContext);
        return t;
    }

    @MustBeDocumented
    @Retention(value=AnnotationRetention.RUNTIME)
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.TYPE, AnnotationTarget.CLASS})
    @SerdeProperties
    @Documented
    @java.lang.annotation.Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.TYPE_USE})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0081\u0002\u0018\u00002\u00020\u0001B\u001c\u0012\u001a\b\u0002\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003B\u0002\b\fR\u001d\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/darkatra/bfme2/map/serialization/ConditionalSerde$Properties;", "", "assetTypes", "", "Lkotlin/reflect/KClass;", "", "()[Ljava/lang/Class;", "map"})
    public static @interface Properties {
        public Class<? extends Object>[] assetTypes() default {};
    }
}

