/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.map.camera.CameraAnimation;
import de.darkatra.bfme2.map.camera.CameraAnimationType;
import de.darkatra.bfme2.map.camera.FreeCameraAnimation;
import de.darkatra.bfme2.map.camera.LookAtCameraAnimation;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerdeFactory;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.DataSection;
import de.darkatra.bfme2.map.serialization.model.DataSectionHolder;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/darkatra/bfme2/map/serialization/CameraAnimationSerde;", "Lde/darkatra/bfme2/map/serialization/Serde;", "Lde/darkatra/bfme2/map/camera/CameraAnimation;", "serdeFactory", "Lde/darkatra/bfme2/map/serialization/SerdeFactory;", "serializationContext", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "<init>", "(Lde/darkatra/bfme2/map/serialization/SerdeFactory;Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;)V", "cameraAnimationTypeSerde", "Lde/darkatra/bfme2/map/camera/CameraAnimationType;", "freeCameraAnimationSerde", "Lde/darkatra/bfme2/map/camera/FreeCameraAnimation;", "lookAtCameraAnimationSerde", "Lde/darkatra/bfme2/map/camera/LookAtCameraAnimation;", "calculateDataSection", "Lde/darkatra/bfme2/map/serialization/model/DataSection;", "data", "serialize", "", "outputStream", "Ljava/io/OutputStream;", "deserialize", "inputStream", "Lcom/google/common/io/CountingInputStream;", "map"})
public final class CameraAnimationSerde
implements Serde<CameraAnimation> {
    @NotNull
    private final SerializationContext serializationContext;
    @NotNull
    private final PreProcessor<CameraAnimation> preProcessor;
    @NotNull
    private final PostProcessor<CameraAnimation> postProcessor;
    @NotNull
    private final Serde<CameraAnimationType> cameraAnimationTypeSerde;
    @NotNull
    private final Serde<FreeCameraAnimation> freeCameraAnimationSerde;
    @NotNull
    private final Serde<LookAtCameraAnimation> lookAtCameraAnimationSerde;

    public CameraAnimationSerde(@NotNull SerdeFactory serdeFactory, @NotNull SerializationContext serializationContext, @NotNull PreProcessor<CameraAnimation> preProcessor, @NotNull PostProcessor<CameraAnimation> postProcessor) {
        Intrinsics.checkNotNullParameter((Object)serdeFactory, (String)"serdeFactory");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        this.serializationContext = serializationContext;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.cameraAnimationTypeSerde = serdeFactory.getSerde$map(Reflection.getOrCreateKotlinClass(CameraAnimationType.class));
        this.freeCameraAnimationSerde = serdeFactory.getSerde$map(Reflection.getOrCreateKotlinClass(FreeCameraAnimation.class));
        this.lookAtCameraAnimationSerde = serdeFactory.getSerde$map(Reflection.getOrCreateKotlinClass(LookAtCameraAnimation.class));
    }

    @Override
    @NotNull
    public DataSection calculateDataSection(@NotNull CameraAnimation data) {
        DataSection dataSection;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CameraAnimation cameraAnimation = data;
        if (cameraAnimation instanceof FreeCameraAnimation) {
            Object[] objectArray = new DataSection[]{this.cameraAnimationTypeSerde.calculateDataSection(CameraAnimationType.FREE), this.freeCameraAnimationSerde.calculateDataSection((FreeCameraAnimation)data)};
            dataSection = new DataSectionHolder(CollectionsKt.listOf((Object[])objectArray), null, null, 6, null);
        } else if (cameraAnimation instanceof LookAtCameraAnimation) {
            Object[] objectArray = new DataSection[]{this.cameraAnimationTypeSerde.calculateDataSection(CameraAnimationType.LOOK), this.lookAtCameraAnimationSerde.calculateDataSection((LookAtCameraAnimation)data)};
            dataSection = new DataSectionHolder(CollectionsKt.listOf((Object[])objectArray), null, null, 6, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dataSection;
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, @NotNull CameraAnimation data) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CameraAnimation cameraAnimation = this.preProcessor.preProcess(data, this.serializationContext);
        boolean bl = false;
        CameraAnimation cameraAnimation2 = cameraAnimation;
        if (cameraAnimation2 instanceof FreeCameraAnimation) {
            this.cameraAnimationTypeSerde.serialize(outputStream, CameraAnimationType.FREE);
            this.freeCameraAnimationSerde.serialize(outputStream, (FreeCameraAnimation)cameraAnimation);
        } else if (cameraAnimation2 instanceof LookAtCameraAnimation) {
            this.cameraAnimationTypeSerde.serialize(outputStream, CameraAnimationType.LOOK);
            this.lookAtCameraAnimationSerde.serialize(outputStream, (LookAtCameraAnimation)cameraAnimation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    @NotNull
    public CameraAnimation deserialize(@NotNull CountingInputStream inputStream) {
        CameraAnimation cameraAnimation;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        CameraAnimationType animationType = (CameraAnimationType)((Object)this.cameraAnimationTypeSerde.deserialize(inputStream));
        CameraAnimation it = cameraAnimation = (switch (WhenMappings.$EnumSwitchMapping$0[animationType.ordinal()]) {
            case 1 -> (CameraAnimation)this.freeCameraAnimationSerde.deserialize(inputStream);
            case 2 -> (CameraAnimation)this.lookAtCameraAnimationSerde.deserialize(inputStream);
            default -> throw new NoWhenBranchMatchedException();
        });
        boolean bl = false;
        this.postProcessor.postProcess(it, this.serializationContext);
        return cameraAnimation;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CameraAnimationType.values().length];
            try {
                nArray[CameraAnimationType.FREE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraAnimationType.LOOK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

