/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.InputStreamExtensionsKt;
import de.darkatra.bfme2.InvalidDataException;
import de.darkatra.bfme2.OutputStreamExtensionsKt;
import de.darkatra.bfme2.map.Asset;
import de.darkatra.bfme2.map.scripting.Script;
import de.darkatra.bfme2.map.scripting.ScriptFolder;
import de.darkatra.bfme2.map.scripting.ScriptListEntry;
import de.darkatra.bfme2.map.serialization.AnnotationProcessingContext;
import de.darkatra.bfme2.map.serialization.AssetListSerde;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerdeFactory;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.AssetEntry;
import de.darkatra.bfme2.map.serialization.model.DataSection;
import de.darkatra.bfme2.map.serialization.model.DataSectionHolder;
import de.darkatra.bfme2.map.serialization.model.DataSectionLeaf;
import de.darkatra.bfme2.map.serialization.postprocessing.NoopPostProcessor;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.NoopPreProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/darkatra/bfme2/map/serialization/ScriptListEntrySerde;", "Lde/darkatra/bfme2/map/serialization/Serde;", "Lde/darkatra/bfme2/map/scripting/ScriptListEntry;", "serdeFactory", "Lde/darkatra/bfme2/map/serialization/SerdeFactory;", "annotationProcessingContext", "Lde/darkatra/bfme2/map/serialization/AnnotationProcessingContext;", "serializationContext", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "<init>", "(Lde/darkatra/bfme2/map/serialization/SerdeFactory;Lde/darkatra/bfme2/map/serialization/AnnotationProcessingContext;Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;)V", "currentElementName", "", "scriptAssetName", "scriptFolderAssetAnnotation", "Lde/darkatra/bfme2/map/Asset;", "assetListSerde", "Lde/darkatra/bfme2/map/serialization/AssetListSerde;", "scriptSerde", "Lde/darkatra/bfme2/map/scripting/Script;", "calculateDataSection", "Lde/darkatra/bfme2/map/serialization/model/DataSection;", "data", "serialize", "", "outputStream", "Ljava/io/OutputStream;", "deserialize", "inputStream", "Lcom/google/common/io/CountingInputStream;", "serializeAssetFolder", "scriptFolder", "Lde/darkatra/bfme2/map/scripting/ScriptFolder;", "deserializeAssetFolder", "failWithException", "", "assetName", "map"})
@SourceDebugExtension(value={"SMAP\nScriptListEntrySerde.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptListEntrySerde.kt\nde/darkatra/bfme2/map/serialization/ScriptListEntrySerde\n+ 2 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n20#2:105\n20#2:108\n295#3,2:106\n295#3,2:109\n*S KotlinDebug\n*F\n+ 1 ScriptListEntrySerde.kt\nde/darkatra/bfme2/map/serialization/ScriptListEntrySerde\n*L\n32#1:105\n33#1:108\n32#1:106,2\n33#1:109,2\n*E\n"})
public final class ScriptListEntrySerde
implements Serde<ScriptListEntry> {
    @NotNull
    private final SerializationContext serializationContext;
    @NotNull
    private final PreProcessor<ScriptListEntry> preProcessor;
    @NotNull
    private final PostProcessor<ScriptListEntry> postProcessor;
    @NotNull
    private final String currentElementName;
    @NotNull
    private final String scriptAssetName;
    @NotNull
    private final Asset scriptFolderAssetAnnotation;
    @NotNull
    private final AssetListSerde<ScriptListEntry> assetListSerde;
    @NotNull
    private final Serde<Script> scriptSerde;

    public ScriptListEntrySerde(@NotNull SerdeFactory serdeFactory, @NotNull AnnotationProcessingContext annotationProcessingContext, @NotNull SerializationContext serializationContext, @NotNull PreProcessor<ScriptListEntry> preProcessor, @NotNull PostProcessor<ScriptListEntry> postProcessor) {
        Object v2;
        block3: {
            Object v0;
            boolean bl;
            Annotation it$iv;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv$iv;
            KAnnotatedElement $this$findAnnotation$iv;
            boolean $i$f$findAnnotation;
            ScriptListEntrySerde scriptListEntrySerde;
            block2: {
                Intrinsics.checkNotNullParameter((Object)serdeFactory, (String)"serdeFactory");
                Intrinsics.checkNotNullParameter((Object)annotationProcessingContext, (String)"annotationProcessingContext");
                Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
                Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
                Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
                this.serializationContext = serializationContext;
                this.preProcessor = preProcessor;
                this.postProcessor = postProcessor;
                this.currentElementName = annotationProcessingContext.getCurrentElement$map().getName();
                KAnnotatedElement kAnnotatedElement = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(Script.class);
                scriptListEntrySerde = this;
                $i$f$findAnnotation = false;
                $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Annotation)element$iv$iv;
                    bl = false;
                    if (!(it$iv instanceof Asset)) continue;
                    v0 = element$iv$iv;
                    break block2;
                }
                v0 = null;
            }
            Annotation annotation = v0;
            Intrinsics.checkNotNull((Object)annotation);
            scriptListEntrySerde.scriptAssetName = ((Asset)annotation).name();
            $this$findAnnotation$iv = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(ScriptFolder.class);
            scriptListEntrySerde = this;
            $i$f$findAnnotation = false;
            $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                it$iv = (Annotation)element$iv$iv;
                bl = false;
                if (!(it$iv instanceof Asset)) continue;
                v2 = element$iv$iv;
                break block3;
            }
            v2 = null;
        }
        Annotation annotation = v2;
        Intrinsics.checkNotNull((Object)annotation);
        scriptListEntrySerde.scriptFolderAssetAnnotation = (Asset)annotation;
        this.assetListSerde = new AssetListSerde(this.serializationContext, this, new NoopPreProcessor(), new NoopPostProcessor());
        this.scriptSerde = serdeFactory.getSerde$map(Reflection.getOrCreateKotlinClass(Script.class));
    }

    @Override
    @NotNull
    public DataSection calculateDataSection(@NotNull ScriptListEntry data) {
        DataSection dataSection;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ScriptListEntry scriptListEntry = data;
        if (scriptListEntry instanceof Script) {
            dataSection = this.scriptSerde.calculateDataSection((Script)data);
        } else if (scriptListEntry instanceof ScriptFolder) {
            Object[] objectArray = new DataSection[]{new DataSectionLeaf(2L + (long)((ScriptFolder)data).getName().length()), DataSectionLeaf.Companion.getBOOLEAN(), DataSectionLeaf.Companion.getBOOLEAN(), this.assetListSerde.calculateDataSection(((ScriptFolder)data).getScriptListEntries())};
            List list = CollectionsKt.listOf((Object[])objectArray);
            dataSection = new DataSectionHolder(list, "ScriptGroup", UShort.box-impl((short)3), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dataSection;
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, @NotNull ScriptListEntry data) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ScriptListEntry scriptListEntry = this.preProcessor.preProcess(data, this.serializationContext);
        boolean bl = false;
        ScriptListEntry scriptListEntry2 = scriptListEntry;
        if (scriptListEntry2 instanceof Script) {
            this.scriptSerde.serialize(outputStream, (Script)scriptListEntry);
        } else if (scriptListEntry2 instanceof ScriptFolder) {
            this.serializeAssetFolder(outputStream, (ScriptFolder)scriptListEntry);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    @NotNull
    public ScriptListEntry deserialize(@NotNull CountingInputStream inputStream) {
        ScriptListEntry scriptListEntry;
        ScriptListEntry scriptListEntry2;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        String assetName = this.serializationContext.peek$map().getAssetName$map();
        if (Intrinsics.areEqual((Object)assetName, (Object)this.scriptAssetName)) {
            scriptListEntry2 = (ScriptListEntry)this.scriptSerde.deserialize(inputStream);
        } else if (Intrinsics.areEqual((Object)assetName, (Object)this.scriptFolderAssetAnnotation.name())) {
            scriptListEntry2 = this.deserializeAssetFolder(inputStream);
        } else {
            this.failWithException(assetName);
            throw new KotlinNothingValueException();
        }
        ScriptListEntry it = scriptListEntry = scriptListEntry2;
        boolean bl = false;
        this.postProcessor.postProcess(it, this.serializationContext);
        return scriptListEntry;
    }

    private final void serializeAssetFolder(OutputStream outputStream, ScriptFolder scriptFolder) {
        OutputStreamExtensionsKt.writeUShortPrefixedString$default((OutputStream)outputStream, (String)scriptFolder.getName(), null, (int)2, null);
        OutputStreamExtensionsKt.writeBoolean((OutputStream)outputStream, (boolean)scriptFolder.getActive());
        OutputStreamExtensionsKt.writeBoolean((OutputStream)outputStream, (boolean)scriptFolder.getSubroutine());
        this.assetListSerde.serialize(outputStream, scriptFolder.getScriptListEntries());
    }

    private final ScriptListEntry deserializeAssetFolder(CountingInputStream inputStream) {
        AssetEntry currentAsset = this.serializationContext.peek$map();
        if (this.scriptFolderAssetAnnotation.version() != currentAsset.getAssetVersion-Mh2AYeg$map()) {
            throw new InvalidDataException("Unexpected assetVersion '" + UShort.toString-impl((short)currentAsset.getAssetVersion-Mh2AYeg$map()) + "' for assetName '" + currentAsset.getAssetName$map() + "' reading " + this.currentElementName + ". Expected: '" + UShort.toString-impl((short)this.scriptFolderAssetAnnotation.version()) + "'", null, 2, null);
        }
        String name = InputStreamExtensionsKt.readUShortPrefixedString$default((InputStream)((InputStream)inputStream), null, (int)1, null);
        boolean active = InputStreamExtensionsKt.readBoolean((InputStream)((InputStream)inputStream));
        boolean subroutine = InputStreamExtensionsKt.readBoolean((InputStream)((InputStream)inputStream));
        Object scripts = this.assetListSerde.deserialize(inputStream);
        return new ScriptFolder(name, active, subroutine, (List<? extends ScriptListEntry>)scripts);
    }

    private final Void failWithException(String assetName) {
        throw new InvalidDataException("Unexpected assetName '" + assetName + "' reading " + this.currentElementName + ". Expected either '" + this.scriptAssetName + "' or '" + this.scriptFolderAssetAnnotation.name() + "'.", null, 2, null);
    }
}

