/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.InputStreamExtensionsKt;
import de.darkatra.bfme2.OutputStreamExtensionsKt;
import de.darkatra.bfme2.Vector3;
import de.darkatra.bfme2.map.scripting.ScriptArgument;
import de.darkatra.bfme2.map.scripting.ScriptArgumentType;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerdeFactory;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.DataSection;
import de.darkatra.bfme2.map.serialization.model.DataSectionHolder;
import de.darkatra.bfme2.map.serialization.model.DataSectionLeaf;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/darkatra/bfme2/map/serialization/ScriptArgumentSerde;", "Lde/darkatra/bfme2/map/serialization/Serde;", "Lde/darkatra/bfme2/map/scripting/ScriptArgument;", "serdeFactory", "Lde/darkatra/bfme2/map/serialization/SerdeFactory;", "serializationContext", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "<init>", "(Lde/darkatra/bfme2/map/serialization/SerdeFactory;Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;)V", "scriptArgumentTypeSerde", "Lde/darkatra/bfme2/map/scripting/ScriptArgumentType;", "calculateDataSection", "Lde/darkatra/bfme2/map/serialization/model/DataSection;", "data", "serialize", "", "outputStream", "Ljava/io/OutputStream;", "deserialize", "inputStream", "Lcom/google/common/io/CountingInputStream;", "map"})
public final class ScriptArgumentSerde
implements Serde<ScriptArgument> {
    @NotNull
    private final SerializationContext serializationContext;
    @NotNull
    private final PreProcessor<ScriptArgument> preProcessor;
    @NotNull
    private final PostProcessor<ScriptArgument> postProcessor;
    @NotNull
    private final Serde<ScriptArgumentType> scriptArgumentTypeSerde;

    public ScriptArgumentSerde(@NotNull SerdeFactory serdeFactory, @NotNull SerializationContext serializationContext, @NotNull PreProcessor<ScriptArgument> preProcessor, @NotNull PostProcessor<ScriptArgument> postProcessor) {
        Intrinsics.checkNotNullParameter((Object)serdeFactory, (String)"serdeFactory");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        this.serializationContext = serializationContext;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.scriptArgumentTypeSerde = serdeFactory.getSerde$map(Reflection.getOrCreateKotlinClass(ScriptArgumentType.class));
    }

    @Override
    @NotNull
    public DataSection calculateDataSection(@NotNull ScriptArgument data) {
        DataSectionLeaf dataSectionLeaf;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object[] objectArray = new DataSection[2];
        objectArray[0] = this.scriptArgumentTypeSerde.calculateDataSection(data.getArgumentType());
        if (WhenMappings.$EnumSwitchMapping$0[data.getArgumentType().ordinal()] == 1) {
            dataSectionLeaf = new DataSectionLeaf(12L);
        } else {
            String string = data.getStringValue();
            Intrinsics.checkNotNull((Object)string);
            dataSectionLeaf = new DataSectionLeaf(10L + (long)string.length());
        }
        objectArray[1] = dataSectionLeaf;
        return new DataSectionHolder(CollectionsKt.listOf((Object[])objectArray), null, null, 6, null);
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, @NotNull ScriptArgument data) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ScriptArgument scriptArgument = this.preProcessor.preProcess(data, this.serializationContext);
        boolean bl = false;
        this.scriptArgumentTypeSerde.serialize(outputStream, scriptArgument.getArgumentType());
        if (WhenMappings.$EnumSwitchMapping$0[scriptArgument.getArgumentType().ordinal()] == 1) {
            Intrinsics.checkNotNull((Object)scriptArgument.getPosition());
            OutputStreamExtensionsKt.writeFloat((OutputStream)outputStream, (float)scriptArgument.getPosition().getX());
            OutputStreamExtensionsKt.writeFloat((OutputStream)outputStream, (float)scriptArgument.getPosition().getY());
            OutputStreamExtensionsKt.writeFloat((OutputStream)outputStream, (float)scriptArgument.getPosition().getZ());
        } else {
            Integer n = scriptArgument.getIntValue();
            Intrinsics.checkNotNull((Object)n);
            OutputStreamExtensionsKt.writeInt((OutputStream)outputStream, (int)n);
            Float f = scriptArgument.getFloatValue();
            Intrinsics.checkNotNull((Object)f);
            OutputStreamExtensionsKt.writeFloat((OutputStream)outputStream, (float)f.floatValue());
            String string = scriptArgument.getStringValue();
            Intrinsics.checkNotNull((Object)string);
            OutputStreamExtensionsKt.writeUShortPrefixedString$default((OutputStream)outputStream, (String)string, null, (int)2, null);
        }
    }

    @Override
    @NotNull
    public ScriptArgument deserialize(@NotNull CountingInputStream inputStream) {
        ScriptArgument scriptArgument;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ScriptArgumentType argumentType = (ScriptArgumentType)((Object)this.scriptArgumentTypeSerde.deserialize(inputStream));
        ScriptArgument it = scriptArgument = WhenMappings.$EnumSwitchMapping$0[argumentType.ordinal()] == 1 ? new ScriptArgument(argumentType, null, null, null, new Vector3(InputStreamExtensionsKt.readFloat((InputStream)((InputStream)inputStream)), InputStreamExtensionsKt.readFloat((InputStream)((InputStream)inputStream)), InputStreamExtensionsKt.readFloat((InputStream)((InputStream)inputStream))), 14, null) : new ScriptArgument(argumentType, InputStreamExtensionsKt.readInt((InputStream)((InputStream)inputStream)), Float.valueOf(InputStreamExtensionsKt.readFloat((InputStream)((InputStream)inputStream))), InputStreamExtensionsKt.readUShortPrefixedString$default((InputStream)((InputStream)inputStream), null, (int)1, null), null, 16, null);
        boolean bl = false;
        this.postProcessor.postProcess(it, this.serializationContext);
        return scriptArgument;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptArgumentType.values().length];
            try {
                nArray[ScriptArgumentType.POSITION_COORDINATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

