/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.InputStreamExtensionsKt;
import de.darkatra.bfme2.OutputStreamExtensionsKt;
import de.darkatra.bfme2.map.property.Property;
import de.darkatra.bfme2.map.property.PropertyKey;
import de.darkatra.bfme2.map.property.PropertyType;
import de.darkatra.bfme2.map.serialization.PropertyKeySerde;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerdeFactory;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.DataSection;
import de.darkatra.bfme2.map.serialization.model.DataSectionHolder;
import de.darkatra.bfme2.map.serialization.model.DataSectionLeaf;
import de.darkatra.bfme2.map.serialization.postprocessing.NoopPostProcessor;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.NoopPreProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/darkatra/bfme2/map/serialization/PropertySerde;", "Lde/darkatra/bfme2/map/serialization/Serde;", "Lde/darkatra/bfme2/map/property/Property;", "serdeFactory", "Lde/darkatra/bfme2/map/serialization/SerdeFactory;", "serializationContext", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "<init>", "(Lde/darkatra/bfme2/map/serialization/SerdeFactory;Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;)V", "propertyKeySerde", "Lde/darkatra/bfme2/map/serialization/PropertyKeySerde;", "calculateDataSection", "Lde/darkatra/bfme2/map/serialization/model/DataSection;", "data", "serialize", "", "outputStream", "Ljava/io/OutputStream;", "deserialize", "inputStream", "Lcom/google/common/io/CountingInputStream;", "map"})
public final class PropertySerde
implements Serde<Property> {
    @NotNull
    private final SerializationContext serializationContext;
    @NotNull
    private final PreProcessor<Property> preProcessor;
    @NotNull
    private final PostProcessor<Property> postProcessor;
    @NotNull
    private final PropertyKeySerde propertyKeySerde;

    public PropertySerde(@NotNull SerdeFactory serdeFactory, @NotNull SerializationContext serializationContext, @NotNull PreProcessor<Property> preProcessor, @NotNull PostProcessor<Property> postProcessor) {
        Intrinsics.checkNotNullParameter((Object)serdeFactory, (String)"serdeFactory");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        this.serializationContext = serializationContext;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.propertyKeySerde = new PropertyKeySerde(serdeFactory, this.serializationContext, new NoopPreProcessor(), new NoopPostProcessor());
    }

    @Override
    @NotNull
    public DataSection calculateDataSection(@NotNull Property data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object[] objectArray = new DataSection[2];
        objectArray[0] = this.propertyKeySerde.calculateDataSection(data.getKey());
        objectArray[1] = switch (WhenMappings.$EnumSwitchMapping$0[data.getKey().getPropertyType().ordinal()]) {
            case 1 -> DataSectionLeaf.Companion.getBOOLEAN();
            case 2 -> DataSectionLeaf.Companion.getINT();
            case 3 -> DataSectionLeaf.Companion.getFLOAT();
            case 4 -> {
                Object v1 = data.getValue();
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.String");
                yield new DataSectionLeaf(2L + (long)((String)v1).length());
            }
            case 5 -> {
                Object v2 = data.getValue();
                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type kotlin.String");
                yield new DataSectionLeaf(2L + (long)(((String)v2).length() * 2));
            }
            case 6 -> {
                Object v3 = data.getValue();
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.String");
                yield new DataSectionLeaf(2L + (long)((String)v3).length());
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        return new DataSectionHolder(CollectionsKt.listOf((Object[])objectArray), null, null, 6, null);
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, @NotNull Property data) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Property property = this.preProcessor.preProcess(data, this.serializationContext);
        boolean bl = false;
        this.propertyKeySerde.serialize(outputStream, property.getKey());
        switch (WhenMappings.$EnumSwitchMapping$0[property.getKey().getPropertyType().ordinal()]) {
            case 1: {
                Object object = property.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                OutputStreamExtensionsKt.writeBoolean((OutputStream)outputStream, (boolean)((Boolean)object));
                break;
            }
            case 2: {
                Object object = property.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.UInt");
                OutputStreamExtensionsKt.writeUInt-Qn1smSk((OutputStream)outputStream, (int)((UInt)object).unbox-impl());
                break;
            }
            case 3: {
                Object object = property.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                OutputStreamExtensionsKt.writeFloat((OutputStream)outputStream, (float)((Float)object).floatValue());
                break;
            }
            case 4: {
                Object object = property.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                OutputStreamExtensionsKt.writeUShortPrefixedString$default((OutputStream)outputStream, (String)((String)object), null, (int)2, null);
                break;
            }
            case 5: {
                Object object = property.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String string = (String)object;
                Charset charset = StandardCharsets.UTF_16LE;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_16LE");
                OutputStreamExtensionsKt.writeUShortPrefixedString((OutputStream)outputStream, (String)string, (Charset)charset);
                break;
            }
            case 6: {
                Object object = property.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                OutputStreamExtensionsKt.writeUShortPrefixedString$default((OutputStream)outputStream, (String)((String)object), null, (int)2, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    @NotNull
    public Property deserialize(@NotNull CountingInputStream inputStream) {
        Property property;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        PropertyKey propertyKey = this.propertyKeySerde.deserialize(inputStream);
        Object value = switch (WhenMappings.$EnumSwitchMapping$0[propertyKey.getPropertyType().ordinal()]) {
            case 1 -> Boolean.valueOf(InputStreamExtensionsKt.readBoolean((InputStream)((InputStream)inputStream)));
            case 2 -> UInt.box-impl((int)InputStreamExtensionsKt.readUInt((InputStream)((InputStream)inputStream)));
            case 3 -> Float.valueOf(InputStreamExtensionsKt.readFloat((InputStream)((InputStream)inputStream)));
            case 4 -> (Comparable)((Object)InputStreamExtensionsKt.readUShortPrefixedString$default((InputStream)((InputStream)inputStream), null, (int)1, null));
            case 5 -> {
                InputStream v1 = (InputStream)inputStream;
                Charset v2 = StandardCharsets.UTF_16LE;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"UTF_16LE");
                yield (Comparable)((Object)InputStreamExtensionsKt.readUShortPrefixedString((InputStream)v1, (Charset)v2));
            }
            case 6 -> (Comparable)((Object)InputStreamExtensionsKt.readUShortPrefixedString$default((InputStream)((InputStream)inputStream), null, (int)1, null));
            default -> throw new NoWhenBranchMatchedException();
        };
        Property it = property = new Property(propertyKey, value);
        boolean bl = false;
        this.postProcessor.postProcess(it, this.serializationContext);
        return property;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PropertyType.values().length];
            try {
                nArray[PropertyType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.FLOAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.ASCII_STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.UNICODE_STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

