/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.ConversionExtensionsKt;
import de.darkatra.bfme2.map.property.PropertyKey;
import de.darkatra.bfme2.map.property.PropertyType;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerdeFactory;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.DataSection;
import de.darkatra.bfme2.map.serialization.model.DataSectionHolder;
import de.darkatra.bfme2.map.serialization.model.DataSectionLeaf;
import de.darkatra.bfme2.map.serialization.postprocessing.PostProcessor;
import de.darkatra.bfme2.map.serialization.preprocessing.PreProcessor;
import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ByteSpreadBuilder;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/darkatra/bfme2/map/serialization/PropertyKeySerde;", "Lde/darkatra/bfme2/map/serialization/Serde;", "Lde/darkatra/bfme2/map/property/PropertyKey;", "serdeFactory", "Lde/darkatra/bfme2/map/serialization/SerdeFactory;", "serializationContext", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "preProcessor", "Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;", "postProcessor", "Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;", "<init>", "(Lde/darkatra/bfme2/map/serialization/SerdeFactory;Lde/darkatra/bfme2/map/serialization/SerializationContext;Lde/darkatra/bfme2/map/serialization/preprocessing/PreProcessor;Lde/darkatra/bfme2/map/serialization/postprocessing/PostProcessor;)V", "propertyTypeSerde", "Lde/darkatra/bfme2/map/property/PropertyType;", "calculateDataSection", "Lde/darkatra/bfme2/map/serialization/model/DataSection;", "data", "serialize", "", "outputStream", "Ljava/io/OutputStream;", "deserialize", "inputStream", "Lcom/google/common/io/CountingInputStream;", "map"})
public final class PropertyKeySerde
implements Serde<PropertyKey> {
    @NotNull
    private final SerializationContext serializationContext;
    @NotNull
    private final PreProcessor<PropertyKey> preProcessor;
    @NotNull
    private final PostProcessor<PropertyKey> postProcessor;
    @NotNull
    private final Serde<PropertyType> propertyTypeSerde;

    public PropertyKeySerde(@NotNull SerdeFactory serdeFactory, @NotNull SerializationContext serializationContext, @NotNull PreProcessor<PropertyKey> preProcessor, @NotNull PostProcessor<PropertyKey> postProcessor) {
        Intrinsics.checkNotNullParameter((Object)serdeFactory, (String)"serdeFactory");
        Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
        Intrinsics.checkNotNullParameter(preProcessor, (String)"preProcessor");
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        this.serializationContext = serializationContext;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.propertyTypeSerde = serdeFactory.getSerde$map(Reflection.getOrCreateKotlinClass(PropertyType.class));
    }

    @Override
    @NotNull
    public DataSection calculateDataSection(@NotNull PropertyKey data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object[] objectArray = new DataSection[]{new DataSectionLeaf(3L), this.propertyTypeSerde.calculateDataSection(data.getPropertyType())};
        return new DataSectionHolder(CollectionsKt.listOf((Object[])objectArray), data.getName(), null, 4, null);
    }

    @Override
    public void serialize(@NotNull OutputStream outputStream, @NotNull PropertyKey data) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PropertyKey propertyKey = this.preProcessor.preProcess(data, this.serializationContext);
        boolean bl = false;
        this.propertyTypeSerde.serialize(outputStream, propertyKey.getPropertyType());
        int assetIndex = this.serializationContext.getAssetIndex-OGnWXxg$map(data.getName());
        outputStream.write(CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])ConversionExtensionsKt.toLittleEndianBytes-WZ4Q5Ns((int)assetIndex), (int)3)));
    }

    @Override
    @NotNull
    public PropertyKey deserialize(@NotNull CountingInputStream inputStream) {
        PropertyKey propertyKey;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        PropertyType propertyType = (PropertyType)((Object)this.propertyTypeSerde.deserialize(inputStream));
        ByteSpreadBuilder byteSpreadBuilder = new ByteSpreadBuilder(2);
        byteSpreadBuilder.addSpread((Object)inputStream.readNBytes(3));
        byteSpreadBuilder.add((byte)0);
        int assetNameIndex = ConversionExtensionsKt.toLittleEndianUInt((byte[])byteSpreadBuilder.toArray());
        String assetName = this.serializationContext.getAssetName-WZ4Q5Ns$map(assetNameIndex);
        PropertyKey it = propertyKey = new PropertyKey(propertyType, assetName);
        boolean bl = false;
        this.postProcessor.postProcess(it, this.serializationContext);
        return propertyKey;
    }
}

