/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import de.darkatra.bfme2.OutputStreamExtensionsKt;
import de.darkatra.bfme2.PublicApi;
import de.darkatra.bfme2.map.Asset;
import de.darkatra.bfme2.map.MapFile;
import de.darkatra.bfme2.map.MapFileCompression;
import de.darkatra.bfme2.map.serialization.AnnotationProcessingContext;
import de.darkatra.bfme2.map.serialization.MapFileSerde;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerdeFactory;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.DataSectionHolder;
import de.darkatra.bfme2.map.serialization.model.DataSectionLeaf;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KAnnotatedElement;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J$\u0010\u0012\u001a\u00020\u00072\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/darkatra/bfme2/map/serialization/MapFileWriter;", "", "debugMode", "", "<init>", "(Z)V", "write", "", "file", "Ljava/nio/file/Path;", "mapFile", "Lde/darkatra/bfme2/map/MapFile;", "compression", "Lde/darkatra/bfme2/map/MapFileCompression;", "outputStream", "Ljava/io/OutputStream;", "bufferedOutputStream", "Ljava/io/BufferedOutputStream;", "writeAssetNames", "assetNames", "", "Lkotlin/UInt;", "", "encodeIfNecessary", "writeFourCC", "fileSize", "", "Companion", "map"})
@SourceDebugExtension(value={"SMAP\nMapFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapFileWriter.kt\nde/darkatra/bfme2/map/serialization/MapFileWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,169:1\n774#2:170\n865#2,2:171\n1663#2,8:173\n1567#2:181\n1598#2,4:182\n126#3:186\n153#3,2:187\n155#3:190\n1#4:189\n18#5,4:191\n50#5,7:195\n*S KotlinDebug\n*F\n+ 1 MapFileWriter.kt\nde/darkatra/bfme2/map/serialization/MapFileWriter\n*L\n94#1:170\n94#1:171,2\n95#1:173,8\n96#1:181\n96#1:182,4\n102#1:186\n102#1:187,2\n102#1:190\n117#1:191,4\n117#1:195,7\n*E\n"})
public final class MapFileWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean debugMode;
    @NotNull
    private static final Map<IntRange, Integer> sevenBitIntSizeMap;

    public MapFileWriter(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public /* synthetic */ MapFileWriter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApi
    public final void write(@NotNull Path file, @NotNull MapFile mapFile, @NotNull MapFileCompression compression) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)mapFile, (String)"mapFile");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new FileAlreadyExistsException("File '" + ((Object)file.toAbsolutePath()).toString() + "' already exist.");
        }
        Object object = file;
        Object object2 = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object = outputStream;
        object2 = null;
        try {
            OutputStream it = (OutputStream)object;
            boolean bl = false;
            this.write(it, mapFile, compression);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    public static /* synthetic */ void write$default(MapFileWriter mapFileWriter, Path path, MapFile mapFile, MapFileCompression mapFileCompression, int n, Object object) {
        if ((n & 4) != 0) {
            mapFileCompression = MapFileCompression.UNCOMPRESSED;
        }
        mapFileWriter.write(path, mapFile, mapFileCompression);
    }

    @PublicApi
    public final void write(@NotNull OutputStream outputStream, @NotNull MapFile mapFile, @NotNull MapFileCompression compression) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)mapFile, (String)"mapFile");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        OutputStream outputStream2 = outputStream;
        int n = 8192;
        this.write(outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n), mapFile, compression);
    }

    public static /* synthetic */ void write$default(MapFileWriter mapFileWriter, OutputStream outputStream, MapFile mapFile, MapFileCompression mapFileCompression, int n, Object object) {
        if ((n & 4) != 0) {
            mapFileCompression = MapFileCompression.UNCOMPRESSED;
        }
        mapFileWriter.write(outputStream, mapFile, mapFileCompression);
    }

    /*
     * WARNING - void declaration
     */
    @PublicApi
    public final void write(@NotNull BufferedOutputStream bufferedOutputStream, @NotNull MapFile mapFile, @NotNull MapFileCompression compression) {
        long l;
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Iterable $this$distinctBy$iv;
        int n3;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)bufferedOutputStream, (String)"bufferedOutputStream");
        Intrinsics.checkNotNullParameter((Object)mapFile, (String)"mapFile");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        if (compression == MapFileCompression.REFPACK) {
            throw new UnsupportedEncodingException("Encoding '" + compression + "' is not supported.");
        }
        SerializationContext serializationContext = new SerializationContext(this.debugMode, null, 2, null);
        AnnotationProcessingContext annotationProcessingContext = new AnnotationProcessingContext(this.debugMode);
        SerdeFactory serdeFactory = new SerdeFactory(annotationProcessingContext, serializationContext);
        Serde serde = serdeFactory.getSerde$map(Reflection.getOrCreateKotlinClass(MapFile.class));
        Intrinsics.checkNotNull(serde, (String)"null cannot be cast to non-null type de.darkatra.bfme2.map.serialization.MapFileSerde");
        MapFileSerde mapFileSerde = (MapFileSerde)serde;
        annotationProcessingContext.invalidate$map();
        DataSectionHolder mapFileDataSection = mapFileSerde.calculateDataSection(mapFile);
        Iterable iterable = mapFileDataSection.flatten$map();
        boolean $i$f$filter = false;
        void var12_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataSectionHolder it = (DataSectionHolder)element$iv$iv;
            n3 = 0;
            if (!it.isAsset$map()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            DataSectionHolder it = (DataSectionHolder)e$iv;
            boolean bl = false;
            String key$iv = it.getAssetName$map();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$mapIndexed22 = false;
        set$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void dataSectionHolder;
            void index;
            if ((n3 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataSectionHolder dataSectionHolder2 = (DataSectionHolder)item$iv$iv;
            int n2 = n3;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            UInt uInt = UInt.box-impl((int)UInt.constructor-impl((int)(UInt.constructor-impl((int)index) + 1)));
            String string = dataSectionHolder.getAssetName$map();
            Intrinsics.checkNotNull((Object)string);
            collection2.add(new Pair((Object)uInt, (Object)string));
        }
        Map assetNames = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        serializationContext.setAssetNames$map(assetNames);
        Map $i$f$mapIndexed22 = assetNames;
        long l2 = DataSectionLeaf.Companion.getINT().getSize();
        long l3 = MapFileCompression.UNCOMPRESSED.getFourCC$map().length();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object var29_50;
            Object v3;
            void assetName;
            long l4;
            block10: {
                Map.Entry item$iv$iv;
                Map.Entry n3 = item$iv$iv = (Map.Entry)iterator.next();
                collection = destination$iv$iv2;
                boolean bl = false;
                Iterable iterable2 = sevenBitIntSizeMap.entrySet();
                l4 = DataSectionLeaf.Companion.getINT().getSize();
                Iterable iterable3 = iterable2;
                for (Object t : iterable3) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl2 = false;
                    if (!((IntRange)it.getKey()).contains(((String)assetName.getValue()).length())) continue;
                    v3 = t;
                    break block10;
                }
                v3 = null;
            }
            Object v4 = var29_50 = v3;
            Intrinsics.checkNotNull(v4);
            collection.add(l4 + ((Number)((Map.Entry)v4).getValue()).longValue() + (long)((String)assetName.getValue()).length());
        }
        collection = (List)destination$iv$iv2;
        int mapFileSize = (int)(l3 + (l2 + CollectionsKt.sumOfLong((Iterable)collection)) + mapFileDataSection.getSize());
        if (compression != MapFileCompression.UNCOMPRESSED) {
            this.writeFourCC(bufferedOutputStream, compression, mapFileSize);
        }
        OutputStream encodedOutputStream = this.encodeIfNecessary(bufferedOutputStream, compression);
        this.writeFourCC(encodedOutputStream, MapFileCompression.UNCOMPRESSED, mapFileSize);
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.writeAssetNames(assetNames, encodedOutputStream);
        long elapsedTime = l = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        boolean bl3 = false;
        if (serializationContext.getDebugMode$map()) {
            System.out.println((Object)("Writing asset names took " + Duration.toString-impl((long)elapsedTime) + "."));
        }
        mapFileSerde.serialize(encodedOutputStream, mapFile);
        if (encodedOutputStream instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)encodedOutputStream).finish();
        }
        encodedOutputStream.flush();
    }

    public static /* synthetic */ void write$default(MapFileWriter mapFileWriter, BufferedOutputStream bufferedOutputStream, MapFile mapFile, MapFileCompression mapFileCompression, int n, Object object) {
        if ((n & 4) != 0) {
            mapFileCompression = MapFileCompression.UNCOMPRESSED;
        }
        mapFileWriter.write(bufferedOutputStream, mapFile, mapFileCompression);
    }

    private final void writeAssetNames(Map<UInt, String> assetNames, OutputStream outputStream) {
        int numberOfAssetStrings = UInt.constructor-impl((int)assetNames.size());
        OutputStreamExtensionsKt.writeUInt-Qn1smSk((OutputStream)outputStream, (int)numberOfAssetStrings);
        int n = numberOfAssetStrings;
        if (UnsignedKt.uintCompare((int)1, (int)n) <= 0) {
            int i;
            do {
                i = n--;
                String string = assetNames.get(UInt.box-impl((int)i));
                Intrinsics.checkNotNull((Object)string);
                OutputStreamExtensionsKt.write7BitIntPrefixedString((OutputStream)outputStream, (String)string);
                OutputStreamExtensionsKt.writeUInt-Qn1smSk((OutputStream)outputStream, (int)i);
            } while (i != 1);
        }
    }

    private final OutputStream encodeIfNecessary(OutputStream outputStream, MapFileCompression compression) {
        return switch (WhenMappings.$EnumSwitchMapping$0[compression.ordinal()]) {
            case 1 -> outputStream;
            case 2 -> {
                String var3_3 = "Requires RefPackOutputStream which is not implemented yet.";
                throw new NotImplementedError("An operation is not implemented: " + var3_3);
            }
            case 3 -> new DeflaterOutputStream(outputStream);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void writeFourCC(OutputStream outputStream, MapFileCompression compression, int fileSize) {
        switch (WhenMappings.$EnumSwitchMapping$0[compression.ordinal()]) {
            case 1: {
                String string = MapFileCompression.UNCOMPRESSED.getFourCC$map();
                Charset charset = StandardCharsets.US_ASCII;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                outputStream.write(byArray);
                break;
            }
            case 2: {
                String string = MapFileCompression.REFPACK.getFourCC$map();
                Charset charset = StandardCharsets.US_ASCII;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                outputStream.write(byArray);
                OutputStreamExtensionsKt.writeInt((OutputStream)outputStream, (int)fileSize);
                break;
            }
            case 3: {
                String string = MapFileCompression.ZLIB.getFourCC$map();
                Charset charset = StandardCharsets.US_ASCII;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                outputStream.write(byArray);
                OutputStreamExtensionsKt.writeInt((OutputStream)outputStream, (int)fileSize);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public MapFileWriter() {
        this(false, 1, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new IntRange(0, 127), (Object)1), TuplesKt.to((Object)new IntRange(128, 16383), (Object)2), TuplesKt.to((Object)new IntRange(16384, 0x1FFFFF), (Object)3), TuplesKt.to((Object)new IntRange(0x200000, 0xFFFFFFF), (Object)4), TuplesKt.to((Object)new IntRange(0x10000000, Integer.MAX_VALUE), (Object)5)};
        sevenBitIntSizeMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\n\u001a\u00020\u000b\"\b\b\u0000\u0010\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\f0\u0013H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lde/darkatra/bfme2/map/serialization/MapFileWriter$Companion;", "", "<init>", "()V", "sevenBitIntSizeMap", "", "Lkotlin/ranges/IntRange;", "", "getSevenBitIntSizeMap$map", "()Ljava/util/Map;", "writeAsset", "", "T", "outputStream", "Ljava/io/OutputStream;", "serializationContext", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "data", "entrySerde", "Lde/darkatra/bfme2/map/serialization/Serde;", "writeAsset$map", "(Ljava/io/OutputStream;Lde/darkatra/bfme2/map/serialization/SerializationContext;Ljava/lang/Object;Lde/darkatra/bfme2/map/serialization/Serde;)V", "map"})
    @SourceDebugExtension(value={"SMAP\nMapFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapFileWriter.kt\nde/darkatra/bfme2/map/serialization/MapFileWriter$Companion\n+ 2 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n20#2:170\n295#3,2:171\n*S KotlinDebug\n*F\n+ 1 MapFileWriter.kt\nde/darkatra/bfme2/map/serialization/MapFileWriter$Companion\n*L\n43#1:170\n43#1:171,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<IntRange, Integer> getSevenBitIntSizeMap$map() {
            return sevenBitIntSizeMap;
        }

        public final <T> void writeAsset$map(@NotNull OutputStream outputStream, @NotNull SerializationContext serializationContext, @NotNull T data, @NotNull Serde<T> entrySerde) {
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Intrinsics.checkNotNullParameter(entrySerde, (String)"entrySerde");
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)Reflection.getOrCreateKotlinClass(data.getClass());
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof Asset)) continue;
                    v0 = element$iv$iv;
                    break block3;
                }
                v0 = null;
            }
            Asset asset = (Asset)((Annotation)v0);
            if (asset == null) {
                throw new IllegalStateException("'" + Reflection.getOrCreateKotlinClass(data.getClass()).getQualifiedName() + "' must be annotated with '" + Reflection.getOrCreateKotlinClass(Asset.class).getSimpleName() + "'.");
            }
            Asset asset2 = asset;
            int assetIndex = serializationContext.getAssetIndex-OGnWXxg$map(asset2.name());
            short assetVersion = asset2.version();
            int assetSize = UInt.constructor-impl((int)((int)entrySerde.calculateDataSection(data).getSize()));
            if (serializationContext.getDebugMode$map()) {
                System.out.println((Object)("Writing asset '" + asset2.name() + "' with size " + UInt.toString-impl((int)assetSize) + "."));
            }
            OutputStreamExtensionsKt.writeUInt-Qn1smSk((OutputStream)outputStream, (int)assetIndex);
            OutputStreamExtensionsKt.writeUShort-i8woANY((OutputStream)outputStream, (short)assetVersion);
            OutputStreamExtensionsKt.writeUInt-Qn1smSk((OutputStream)outputStream, (int)assetSize);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MapFileCompression.values().length];
            try {
                nArray[MapFileCompression.UNCOMPRESSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapFileCompression.REFPACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapFileCompression.ZLIB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

