/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2.map.serialization;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import de.darkatra.bfme2.InputStreamExtensionsKt;
import de.darkatra.bfme2.InvalidDataException;
import de.darkatra.bfme2.PublicApi;
import de.darkatra.bfme2.SkippingInputStream;
import de.darkatra.bfme2.map.MapFile;
import de.darkatra.bfme2.map.MapFileCompression;
import de.darkatra.bfme2.map.serialization.AnnotationProcessingContext;
import de.darkatra.bfme2.map.serialization.RollingWindowInputStream;
import de.darkatra.bfme2.map.serialization.Serde;
import de.darkatra.bfme2.map.serialization.SerdeFactory;
import de.darkatra.bfme2.map.serialization.SerializationContext;
import de.darkatra.bfme2.map.serialization.model.AssetEntry;
import de.darkatra.bfme2.refpack.RefPackInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ParameterName;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.UnsignedKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\n\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/darkatra/bfme2/map/serialization/MapFileReader;", "", "debugMode", "", "<init>", "(Z)V", "read", "Lde/darkatra/bfme2/map/MapFile;", "file", "Ljava/nio/file/Path;", "inputStream", "Ljava/io/InputStream;", "bufferedInputStream", "Ljava/io/BufferedInputStream;", "getInputStreamSize", "", "readAssetNames", "", "Lkotlin/UInt;", "", "Lcom/google/common/io/CountingInputStream;", "decodeIfNecessary", "readAndValidateFourCC", "", "Companion", "map"})
@SourceDebugExtension(value={"SMAP\nMapFileReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapFileReader.kt\nde/darkatra/bfme2/map/serialization/MapFileReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,180:1\n1#2:181\n18#3,4:182\n50#3,7:186\n*S KotlinDebug\n*F\n+ 1 MapFileReader.kt\nde/darkatra/bfme2/map/serialization/MapFileReader\n*L\n98#1:182,4\n98#1:186,7\n*E\n"})
public final class MapFileReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean debugMode;

    public MapFileReader(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public /* synthetic */ MapFileReader(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApi
    @NotNull
    public final MapFile read(@NotNull Path file) {
        MapFile mapFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new FileNotFoundException("File '" + ((Object)file.toAbsolutePath()).toString() + "' does not exist.");
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream p0 = (InputStream)closeable;
            boolean bl = false;
            mapFile = this.read(p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return mapFile;
    }

    @PublicApi
    @NotNull
    public final MapFile read(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InputStream inputStream2 = inputStream;
        int n = 8192;
        return this.read(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n));
    }

    @PublicApi
    @NotNull
    public final MapFile read(@NotNull BufferedInputStream bufferedInputStream) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)bufferedInputStream, (String)"bufferedInputStream");
        long inputStreamSize = this.getInputStreamSize(bufferedInputStream);
        InputStream it = this.decodeIfNecessary(bufferedInputStream);
        boolean bl = false;
        boolean bl2 = this.debugMode;
        if (bl2) {
            inputStream = new RollingWindowInputStream(it, 32);
        } else if (!bl2) {
            inputStream = it;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        InputStream inputStream2 = inputStream;
        CountingInputStream countingInputStream = new CountingInputStream(inputStream2);
        this.readAndValidateFourCC((InputStream)countingInputStream);
        SerializationContext serializationContext = new SerializationContext(this.debugMode, null, 2, null);
        AnnotationProcessingContext annotationProcessingContext = new AnnotationProcessingContext(this.debugMode);
        SerdeFactory serdeFactory = new SerdeFactory(annotationProcessingContext, serializationContext);
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl3 = false;
        Map<UInt, String> assetNames = this.readAssetNames(countingInputStream);
        serializationContext.setAssetNames$map(assetNames);
        long elapsedTime = $i$f$measureTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        boolean bl4 = false;
        if (serializationContext.getDebugMode$map()) {
            System.out.println((Object)("Reading asset names took " + Duration.toString-impl((long)elapsedTime) + "."));
        }
        serializationContext.push$map(new AssetEntry("Map", 0, inputStreamSize, 0L, null));
        Serde mapFileSerde = serdeFactory.getSerde$map(Reflection.getOrCreateKotlinClass(MapFile.class));
        annotationProcessingContext.invalidate$map();
        MapFile mapFile = (MapFile)mapFileSerde.deserialize(countingInputStream);
        serializationContext.pop$map();
        return mapFile;
    }

    private final long getInputStreamSize(BufferedInputStream bufferedInputStream) {
        if (!bufferedInputStream.markSupported()) {
            throw new IllegalArgumentException("Can only parse InputStreams with mark support.");
        }
        bufferedInputStream.mark(Integer.MAX_VALUE);
        long inputStreamSize = ByteStreams.exhaust((InputStream)this.decodeIfNecessary(bufferedInputStream));
        bufferedInputStream.reset();
        return inputStreamSize;
    }

    private final Map<UInt, String> readAssetNames(CountingInputStream inputStream) {
        int numberOfAssetStrings = InputStreamExtensionsKt.readUInt((InputStream)((InputStream)inputStream));
        Map assetNames = new LinkedHashMap();
        int n = numberOfAssetStrings;
        if (UnsignedKt.uintCompare((int)1, (int)n) <= 0) {
            int i;
            do {
                i = n--;
                String assetName = InputStreamExtensionsKt.read7BitIntPrefixedString((InputStream)((InputStream)inputStream));
                int assetIndex = InputStreamExtensionsKt.readUInt((InputStream)((InputStream)inputStream));
                if (assetIndex != i) {
                    throw new IllegalStateException("Illegal assetIndex for '" + assetName + "'.");
                }
                UInt uInt = UInt.box-impl((int)assetIndex);
                assetNames.put(uInt, assetName);
            } while (i != 1);
        }
        return assetNames;
    }

    private final InputStream decodeIfNecessary(InputStream inputStream) {
        InputStream inputStream2;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4);
        byte[] fourCCBytes = pushbackInputStream.readNBytes(4);
        Intrinsics.checkNotNull((Object)fourCCBytes);
        Object object = fourCCBytes;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String string = new String((byte[])object, charset2);
        if (Intrinsics.areEqual((Object)string, (Object)MapFileCompression.UNCOMPRESSED.getFourCC$map())) {
            Object it = object = (Object)pushbackInputStream;
            boolean bl = false;
            ((PushbackInputStream)it).unread(fourCCBytes);
            inputStream2 = (InputStream)object;
        } else if (Intrinsics.areEqual((Object)string, (Object)MapFileCompression.REFPACK.getFourCC$map())) {
            inputStream2 = (InputStream)new RefPackInputStream((InputStream)new SkippingInputStream((InputStream)pushbackInputStream, 4L));
        } else if (Intrinsics.areEqual((Object)string, (Object)MapFileCompression.ZLIB.getFourCC$map())) {
            inputStream2 = new InflaterInputStream((InputStream)new SkippingInputStream((InputStream)pushbackInputStream, 4L));
        } else {
            throw new UnsupportedEncodingException("Encoding '" + fourCCBytes + "' is not supported.");
        }
        return inputStream2;
    }

    private final void readAndValidateFourCC(InputStream inputStream) {
        byte[] byArray = inputStream.readNBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"US_ASCII");
        Charset charset2 = charset;
        String fourCC = new String(byArray2, charset2);
        if (!Intrinsics.areEqual((Object)fourCC, (Object)MapFileCompression.UNCOMPRESSED.getFourCC$map())) {
            throw new InvalidDataException("Invalid four character code. Expected '" + MapFileCompression.UNCOMPRESSED.getFourCC$map() + "' but found '" + fourCC + "'.", null, 2, null);
        }
    }

    public MapFileReader() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00050\u000bH\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lde/darkatra/bfme2/map/serialization/MapFileReader$Companion;", "", "<init>", "()V", "readAssets", "", "inputStream", "Lcom/google/common/io/CountingInputStream;", "serializationContext", "Lde/darkatra/bfme2/map/serialization/SerializationContext;", "callback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "assetName", "readAssets$map", "map"})
    public static final class Companion {
        private Companion() {
        }

        public final void readAssets$map(@NotNull CountingInputStream inputStream, @NotNull SerializationContext serializationContext, @NotNull Function1<@ParameterName(name="assetName") ? super String, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)serializationContext, (String)"serializationContext");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            while (inputStream.getCount() < serializationContext.getCurrentEndPosition$map()) {
                int assetIndex = InputStreamExtensionsKt.readUInt((InputStream)((InputStream)inputStream));
                String assetName = serializationContext.getAssetName-WZ4Q5Ns$map(assetIndex);
                AssetEntry currentAsset = new AssetEntry(assetName, InputStreamExtensionsKt.readUShort((InputStream)((InputStream)inputStream)), (long)InputStreamExtensionsKt.readUInt((InputStream)((InputStream)inputStream)) & 0xFFFFFFFFL, inputStream.getCount(), null);
                if (serializationContext.getDebugMode$map()) {
                    System.out.println((Object)("Reading asset '" + currentAsset.getAssetName$map() + "' with size " + currentAsset.getAssetSize$map() + "."));
                }
                serializationContext.push$map(currentAsset);
                callback.invoke((Object)assetName);
                serializationContext.pop$map();
                long currentEndPosition = inputStream.getCount();
                long expectedEndPosition = currentAsset.getEndPosition$map();
                if (serializationContext.getDebugMode$map() || currentEndPosition == expectedEndPosition) continue;
                throw new InvalidDataException("Error reading '" + currentAsset.getAssetName$map() + "'. Expected reader to be at position " + expectedEndPosition + ", but was at " + currentEndPosition + ".", null, 2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

