/*
 * Decompiled with CFR 0.152.
 */
package de.darkatra.bfme2;

import de.darkatra.bfme2.ConversionExtensionsKt;
import de.darkatra.bfme2.InvalidDataException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u000f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u00a2\u0006\u0002\u0010\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0002\u001a\u000f\u0010\n\u001a\u00020\u000b*\u00020\u0002\u00a2\u0006\u0002\u0010\f\u001a\u000f\u0010\r\u001a\u00020\u000e*\u00020\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0013*\u00020\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0016*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\u001b\u001a\u00020\u0016*\u00020\u0002\u00a8\u0006\u001c"}, d2={"readByte", "", "Ljava/io/InputStream;", "readShort", "", "readUShort", "Lkotlin/UShort;", "(Ljava/io/InputStream;)S", "readInt", "", "readUInt", "Lkotlin/UInt;", "(Ljava/io/InputStream;)I", "readULong", "Lkotlin/ULong;", "(Ljava/io/InputStream;)J", "readFloat", "", "readBoolean", "", "readUIntAsBoolean", "readUShortPrefixedString", "", "charset", "Ljava/nio/charset/Charset;", "readNullTerminatedString", "read7BitInt", "read7BitIntPrefixedString", "core"})
@SourceDebugExtension(value={"SMAP\nInputStreamExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputStreamExtensions.kt\nde/darkatra/bfme2/InputStreamExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,91:1\n19960#2,7:92\n*S KotlinDebug\n*F\n+ 1 InputStreamExtensions.kt\nde/darkatra/bfme2/InputStreamExtensionsKt\n*L\n18#1:92,7\n*E\n"})
public final class InputStreamExtensionsKt {
    public static final byte readByte(@NotNull InputStream $this$readByte) {
        Intrinsics.checkNotNullParameter((Object)$this$readByte, (String)"<this>");
        byte[] byArray = $this$readByte.readNBytes(1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return ArraysKt.first((byte[])byArray);
    }

    public static final short readShort(@NotNull InputStream $this$readShort) {
        Intrinsics.checkNotNullParameter((Object)$this$readShort, (String)"<this>");
        byte[] byArray = $this$readShort.readNBytes(2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return ConversionExtensionsKt.toLittleEndianShort(byArray);
    }

    public static final short readUShort(@NotNull InputStream $this$readUShort) {
        Intrinsics.checkNotNullParameter((Object)$this$readUShort, (String)"<this>");
        byte[] byArray = $this$readUShort.readNBytes(2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return ConversionExtensionsKt.toLittleEndianUShort(byArray);
    }

    public static final int readInt(@NotNull InputStream $this$readInt) {
        Intrinsics.checkNotNullParameter((Object)$this$readInt, (String)"<this>");
        byte[] byArray = $this$readInt.readNBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return ConversionExtensionsKt.toLittleEndianInt(byArray);
    }

    public static final int readUInt(@NotNull InputStream $this$readUInt) {
        Intrinsics.checkNotNullParameter((Object)$this$readUInt, (String)"<this>");
        byte[] byArray = $this$readUInt.readNBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return ConversionExtensionsKt.toLittleEndianUInt(byArray);
    }

    public static final long readULong(@NotNull InputStream $this$readULong) {
        Intrinsics.checkNotNullParameter((Object)$this$readULong, (String)"<this>");
        byte[] byArray = $this$readULong.readNBytes(8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return ConversionExtensionsKt.toLittleEndianULong(byArray);
    }

    public static final float readFloat(@NotNull InputStream $this$readFloat) {
        Intrinsics.checkNotNullParameter((Object)$this$readFloat, (String)"<this>");
        byte[] byArray = $this$readFloat.readNBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return ConversionExtensionsKt.toLittleEndianFloat(byArray);
    }

    public static final boolean readBoolean(@NotNull InputStream $this$readBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$readBoolean, (String)"<this>");
        return ConversionExtensionsKt.toBoolean(InputStreamExtensionsKt.readByte($this$readBoolean));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean readUIntAsBoolean(@NotNull InputStream $this$readUIntAsBoolean) {
        byte unused;
        Intrinsics.checkNotNullParameter((Object)$this$readUIntAsBoolean, (String)"<this>");
        boolean result = ConversionExtensionsKt.toBoolean(InputStreamExtensionsKt.readByte($this$readUIntAsBoolean));
        byte[] byArray = $this$readUIntAsBoolean.readNBytes(3);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        byte[] $this$reduce$iv = byArray;
        boolean $i$f$reduce = false;
        if ($this$reduce$iv.length == 0) {
            throw new UnsupportedOperationException("Empty array can't be reduced.");
        }
        byte accumulator$iv = $this$reduce$iv[0];
        int index$iv = 1;
        int n = ArraysKt.getLastIndex((byte[])$this$reduce$iv);
        if (index$iv <= n) {
            while (true) {
                void byteVal;
                byte by = $this$reduce$iv[index$iv];
                byte acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = (byte)(acc | byteVal);
                if (index$iv == n) break;
                ++index$iv;
            }
        }
        if ((unused = accumulator$iv) != 0) {
            throw new InvalidDataException("Unexpected non empty bytes after boolean found.", null, 2, null);
        }
        return result;
    }

    @NotNull
    public static final String readUShortPrefixedString(@NotNull InputStream $this$readUShortPrefixedString, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$readUShortPrefixedString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        int amountOfBytesPerCharacter = Intrinsics.areEqual((Object)charset, (Object)StandardCharsets.UTF_16LE) ? 2 : 1;
        short stringLength = InputStreamExtensionsKt.readUShort($this$readUShortPrefixedString);
        byte[] byArray = $this$readUShortPrefixedString.readNBytes(amountOfBytesPerCharacter * (stringLength & 0xFFFF));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        byte[] byArray2 = byArray;
        return new String(byArray2, charset);
    }

    public static /* synthetic */ String readUShortPrefixedString$default(InputStream inputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            Charset charset2 = StandardCharsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"US_ASCII");
            charset = charset2;
        }
        return InputStreamExtensionsKt.readUShortPrefixedString(inputStream, charset);
    }

    @NotNull
    public static final String readNullTerminatedString(@NotNull InputStream $this$readNullTerminatedString) {
        Intrinsics.checkNotNullParameter((Object)$this$readNullTerminatedString, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder();
        int nextByte = $this$readNullTerminatedString.read();
        while (nextByte != 0) {
            if (nextByte == -1) {
                throw new InvalidDataException("Unexpected end of stream while reading null terminated string.", null, 2, null);
            }
            stringBuilder.append((char)nextByte);
            nextByte = $this$readNullTerminatedString.read();
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final int read7BitInt(@NotNull InputStream $this$read7BitInt) {
        byte by;
        Intrinsics.checkNotNullParameter((Object)$this$read7BitInt, (String)"<this>");
        int result = 0;
        int maxBytesWithoutOverflow = 4;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(maxBytesWithoutOverflow * 7))), (int)7);
        int shift = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && shift <= n || n2 < 0 && n <= shift) {
            while (true) {
                byte by2 = UByte.constructor-impl((byte)InputStreamExtensionsKt.readByte($this$read7BitInt));
                result |= (UByte.constructor-impl((byte)((byte)(by2 & UByte.constructor-impl((byte)((byte)127))))) & 0xFF) << shift;
                if (Intrinsics.compare((int)(by2 & 0xFF), (int)(UByte.constructor-impl((byte)((byte)127)) & 0xFF)) <= 0) {
                    return result;
                }
                if (shift == n) break;
                shift += n2;
            }
        }
        if (Intrinsics.compare((int)((by = UByte.constructor-impl((byte)InputStreamExtensionsKt.readByte($this$read7BitInt))) & 0xFF), (int)(UByte.constructor-impl((byte)((byte)15)) & 0xFF)) > 0) {
            throw new NumberFormatException("Could not read 7bit encoded Int. 5th byte had more than 4 least significant bits set.");
        }
        return result | (UByte.constructor-impl((byte)((byte)(by & UByte.constructor-impl((byte)((byte)127))))) & 0xFF) << maxBytesWithoutOverflow * 7;
    }

    @NotNull
    public static final String read7BitIntPrefixedString(@NotNull InputStream $this$read7BitIntPrefixedString) {
        Intrinsics.checkNotNullParameter((Object)$this$read7BitIntPrefixedString, (String)"<this>");
        int stringLength = InputStreamExtensionsKt.read7BitInt($this$read7BitIntPrefixedString);
        if (stringLength < 0) {
            throw new IllegalStateException("Invalid String length read from stream: '" + stringLength + "'");
        }
        if (stringLength == 0) {
            return "";
        }
        byte[] byArray = $this$read7BitIntPrefixedString.readNBytes(stringLength);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray2, charset2);
    }
}

