/*
 * Decompiled with CFR 0.152.
 */
package de.dandit.cartogram.geo.data;

import de.dandit.cartogram.geo.data.CsvData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CsvDataImport {
    public CsvData importCsv(InputStream dataResource) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(dataResource));){
            String line;
            boolean isHeader = true;
            List headerNames = null;
            List headerTypes = null;
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            while ((line = reader.readLine()) != null) {
                String[] splitData = line.split(",");
                if (isHeader) {
                    headerNames = Arrays.stream(splitData).map(nameAndType -> nameAndType.split(":")[0]).collect(Collectors.toList());
                    headerTypes = Arrays.stream(splitData).map(nameAndType -> nameAndType.split(":")[1]).collect(Collectors.toList());
                    isHeader = false;
                    continue;
                }
                Object[] currData = new Object[splitData.length];
                if (currData.length != headerNames.size()) {
                    throw new IllegalArgumentException("Line data size does not match number of header columns");
                }
                for (int i = 0; i < splitData.length; ++i) {
                    currData[i] = this.convertValueToType((String)headerTypes.get(i), splitData[i]);
                }
                data.add(currData);
            }
            CsvData csvData = new CsvData(headerNames, data);
            return csvData;
        }
    }

    private Object convertValueToType(String type, String readData) {
        if (readData == null || readData.length() == 0) {
            return null;
        }
        switch (type) {
            case "Integer": {
                return Integer.parseInt(readData);
            }
            case "Double": {
                return Double.parseDouble(readData);
            }
        }
        return readData;
    }
}

