/*
 * Decompiled with CFR 0.152.
 */
package de.dandit.cartogram.geo.convert;

import de.dandit.cartogram.core.api.LightPolygon;
import de.dandit.cartogram.core.api.Region;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class GeometryConverter {
    private final GeometryFactory geometryFactory;

    public GeometryConverter(GeometryFactory geometryFactory) {
        this.geometryFactory = Objects.requireNonNull(geometryFactory);
    }

    public Polygon asPolygon(double[] pointsX, double[] pointsY, List<double[]> interiorRingsX, List<double[]> interiorRingsY) {
        LinearRing outerRing = this.asRing(pointsX, pointsY);
        LinearRing[] interiorRings = new LinearRing[interiorRingsX.size()];
        for (int i = 0; i < interiorRingsX.size(); ++i) {
            interiorRings[i] = this.asRing(interiorRingsX.get(i), interiorRingsY.get(i));
        }
        return this.geometryFactory.createPolygon(outerRing, interiorRings);
    }

    private LinearRing asRing(double[] pointsX, double[] pointsY) {
        Coordinate[] coords = new Coordinate[pointsX.length];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = new Coordinate(pointsX[i], pointsY[i]);
        }
        return this.geometryFactory.createLinearRing(coords);
    }

    public Region createFromPolygon(Function<Integer, Double> valueProvider, int regionId, Polygon polygon) {
        return new Region(regionId, valueProvider.apply(regionId).doubleValue(), List.of(this.asLightPolygon(polygon)));
    }

    public Region createFromMultiPolygon(Function<Integer, Double> valueProvider, int regionId, MultiPolygon multiPolygon) {
        multiPolygon.normalize();
        ArrayList<LightPolygon> polygons = new ArrayList<LightPolygon>();
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            polygons.add(this.asLightPolygon((Polygon)multiPolygon.getGeometryN(i)));
        }
        return new Region(regionId, valueProvider.apply(regionId).doubleValue(), polygons);
    }

    private LightPolygon asLightPolygon(Polygon polygon) {
        polygon.normalize();
        ArrayList<double[]> interiorRingsX = new ArrayList<double[]>(polygon.getNumInteriorRing());
        ArrayList<double[]> interiorRingsY = new ArrayList<double[]>(polygon.getNumInteriorRing());
        double[] exteriorRingX = GeometryConverter.convertCoordinatesX(polygon.getExteriorRing());
        double[] exteriorRingY = GeometryConverter.convertCoordinatesY(polygon.getExteriorRing());
        for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
            interiorRingsX.add(GeometryConverter.convertCoordinatesX(polygon.getInteriorRingN(j)));
            interiorRingsY.add(GeometryConverter.convertCoordinatesY(polygon.getInteriorRingN(j)));
        }
        return new LightPolygon(exteriorRingX, exteriorRingY, interiorRingsX, interiorRingsY);
    }

    private static double[] convertCoordinatesX(LineString lineString) {
        return Arrays.stream(lineString.getCoordinates()).mapToDouble(coord -> coord.x).toArray();
    }

    private static double[] convertCoordinatesY(LineString lineString) {
        return Arrays.stream(lineString.getCoordinates()).mapToDouble(coord -> coord.y).toArray();
    }

    public Geometry createGeometry(List<LightPolygon> resultPolygons) {
        Polygon geometry;
        if (resultPolygons.size() == 0) {
            geometry = this.geometryFactory.createPolygon();
        } else if (resultPolygons.size() == 1) {
            LightPolygon polygon = resultPolygons.get(0);
            geometry = this.asPolygon(polygon.getExteriorRingX(), polygon.getExteriorRingY(), polygon.getInteriorRingsX(), polygon.getInteriorRingsY());
        } else {
            Polygon[] polygons = new Polygon[resultPolygons.size()];
            for (int i = 0; i < resultPolygons.size(); ++i) {
                Polygon polygon;
                LightPolygon p = resultPolygons.get(i);
                polygons[i] = polygon = this.asPolygon(p.getExteriorRingX(), p.getExteriorRingY(), p.getInteriorRingsX(), p.getInteriorRingsY());
            }
            geometry = this.geometryFactory.createMultiPolygon(polygons);
        }
        return geometry;
    }
}

