/*
 * Decompiled with CFR 0.152.
 */
package jwebform.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jwebform.element.NumberType;
import jwebform.element.PasswordType;
import jwebform.element.RadioType;
import jwebform.element.SelectType;
import jwebform.element.TextType;
import jwebform.element.structure.Decoration;
import jwebform.element.structure.Element;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.ElementResult;
import jwebform.validation.ValidationResult;
import jwebform.validation.Validator;

public class ProducerInfos {
    private final String formId;
    private final int tabIndex;
    private final ElementContainer elementContainer;
    private final ElementResult elementResult;
    private final List<ProducerInfos> childs;
    private static final List<ProducerInfos> NO_CHILDS = new ArrayList<ProducerInfos>();

    public ProducerInfos(String formId, int tabIndex, ElementResult elementResult, ElementContainer elementContainer, List<ProducerInfos> childs) {
        this.formId = formId;
        this.tabIndex = tabIndex;
        this.elementContainer = elementContainer;
        this.childs = childs;
        this.elementResult = elementResult;
    }

    public ProducerInfos(String formId, int tabIndex, ElementResult elementResult, ElementContainer elementContainer) {
        this(formId, tabIndex, elementResult, elementContainer, NO_CHILDS);
    }

    public List<ProducerInfos> getChilds() {
        return this.childs;
    }

    public ProducerInfos getTabIndexIncreased() {
        return new ProducerInfos(this.formId, this.tabIndex + 1, this.elementResult, this.elementContainer, this.childs);
    }

    public String getHtml() {
        return this.elementResult.getStaticElementInfo().getHtmlProducer().getHTML(this);
    }

    public String getFormId() {
        return this.formId;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public Element getElement() {
        return this.elementContainer.element;
    }

    public String getName() {
        return this.elementResult.getStaticElementInfo().getName();
    }

    public String getElementTypeName() {
        return this.elementContainer.element.getClass().getName();
    }

    public Decoration getDecoration() {
        return this.elementContainer.decoration;
    }

    public String getValue() {
        return this.elementResult.getValue();
    }

    public Object getValueObject() {
        return this.elementResult.getValueObject();
    }

    public Validator getValidator() {
        return this.elementContainer.validator;
    }

    public ValidationResult getValidationResult() {
        return this.elementResult.getValidationResult();
    }

    public ElementResult getElementResult() {
        return this.elementResult;
    }

    public Map<String, Object> getElementInfoMap() {
        HashMap<String, Object> elementNameInfo = new HashMap<String, Object>();
        elementNameInfo.put(this.getTypeName(this.elementContainer.element), Boolean.TRUE);
        if (this.elementContainer.element instanceof TextType) {
            elementNameInfo.put("type", "text");
        } else if (this.elementContainer.element instanceof NumberType) {
            elementNameInfo.put("type", "number");
        } else if (this.elementContainer.element instanceof PasswordType) {
            elementNameInfo.put("type", "password");
        }
        if (this.elementContainer.element instanceof SelectType) {
            SelectType select = (SelectType)this.elementContainer.element;
            elementNameInfo.put("selected", select.getSelectListWithSelected(this.elementResult.getValue()));
        }
        if (this.elementContainer.element instanceof RadioType) {
            RadioType radio = (RadioType)this.elementContainer.element;
            elementNameInfo.put("radioElements", radio.getEntryListWithSelected(this.elementResult.getValue()));
        }
        return elementNameInfo;
    }

    private String getTypeName(Element element) {
        return element.getClass().getName().replaceAll("jwebform\\.element\\.", "");
    }
}

