/*
 * Decompiled with CFR 0.152.
 */
package jwebform.validation.criteria;

import jwebform.validation.Criterion;
import jwebform.validation.criteria.Accept;
import jwebform.validation.criteria.And;
import jwebform.validation.criteria.Email;
import jwebform.validation.criteria.ExactLength;
import jwebform.validation.criteria.Length;
import jwebform.validation.criteria.Max;
import jwebform.validation.criteria.MaxLength;
import jwebform.validation.criteria.Min;
import jwebform.validation.criteria.MinLength;
import jwebform.validation.criteria.Number;
import jwebform.validation.criteria.Or;
import jwebform.validation.criteria.PostcodeCA;
import jwebform.validation.criteria.Range;
import jwebform.validation.criteria.Regex;
import jwebform.validation.criteria.Required;
import jwebform.validation.criteria.StartsWith;
import jwebform.validation.criteria.StrongPassword;
import jwebform.validation.criteria.ZipCode;

public class Criteria {
    private static final Email email = new Email();
    private static final ZipCode zipCode = new ZipCode();
    private static final PostcodeCA postcodeCA = new PostcodeCA();

    private Criteria() {
    }

    public static Criterion required() {
        return Required.getInstance();
    }

    public static Criterion and(Criterion ... criteria) {
        return new And(criteria);
    }

    public static Criterion or(Criterion ... criteria) {
        return new Or(criteria);
    }

    public static Criterion accept(String ... values) {
        return new Accept(values);
    }

    public static Criterion acceptIgnoreCase(String ... values) {
        return new Accept(values).ignoreCase();
    }

    public static Criterion min(int min) {
        return new Min(min);
    }

    public static Criterion max(int max) {
        return new Max(max);
    }

    public static Criterion number() {
        return new Number();
    }

    public static Criterion range(int min, int max) {
        return new Range(min, max);
    }

    public static Criterion length(int min, int max) {
        return new Length(min, max);
    }

    public static Criterion exactLength(int length) {
        return new ExactLength(length);
    }

    public static Criterion minLength(int min) {
        return new MinLength(min);
    }

    public static Criterion maxLength(int max) {
        return new MaxLength(max);
    }

    public static Criterion regex(String pattern) {
        return new Regex(pattern);
    }

    public static Criterion regexIgnoreCase(String pattern) {
        return new Regex(pattern).ignoreCose();
    }

    public static Criterion startsWith(String ... prefix) {
        return new StartsWith(prefix);
    }

    public static Criterion email() {
        return email;
    }

    public static Criterion strongPassword(int minLength) {
        return new StrongPassword(minLength);
    }

    public static Criterion zipcode() {
        return zipCode;
    }

    public static Criterion postcodeCA() {
        return postcodeCA;
    }
}

