/*
 * Decompiled with CFR 0.152.
 */
package jwebform.validation.criteria;

import jwebform.validation.Criterion;
import jwebform.validation.ValidationResult;

public class Accept
implements Criterion {
    private final String[] acceptableValues;
    private final boolean caseSensitive;

    Accept(String ... values) {
        this.acceptableValues = values;
        this.caseSensitive = true;
    }

    private Accept(boolean caseSensitive, String ... values) {
        this.caseSensitive = caseSensitive;
        this.acceptableValues = values;
    }

    protected boolean areEqual(String v1, String v2) {
        if (this.caseSensitive) {
            return v1.equals(v2);
        }
        return v1.equalsIgnoreCase(v2);
    }

    @Override
    public ValidationResult validate(String value) {
        boolean isValid = false;
        for (String v : this.acceptableValues) {
            if (!this.areEqual(v, value)) continue;
            isValid = true;
        }
        if (!isValid) {
            return ValidationResult.fail("jformchecker.allowed_values", this.acceptableValues);
        }
        return ValidationResult.ok();
    }

    public Criterion ignoreCase() {
        return new Accept(false, this.acceptableValues);
    }
}

