/*
 * Decompiled with CFR 0.152.
 */
package jwebform.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jwebform.validation.Criterion;
import jwebform.validation.ValidationResult;
import jwebform.validation.criteria.Criteria;
import jwebform.validation.criteria.MaxLength;

public class Validator {
    private final List<Criterion> criteria = new ArrayList<Criterion>();
    private static final Validator EMPTY_VALIDATOR = new Validator(new Criterion[0]);

    public Validator(Criterion ... inputCriterium) {
        Collections.addAll(this.criteria, inputCriterium);
    }

    public static Validator emptyValidator() {
        return EMPTY_VALIDATOR;
    }

    public boolean isRequired() {
        for (Criterion criterion : this.criteria) {
            if (criterion != Criteria.required()) continue;
            return true;
        }
        return false;
    }

    public Optional<MaxLength> getMaxLen() {
        for (Criterion criterion : this.criteria) {
            if (!(criterion instanceof MaxLength)) continue;
            return Optional.of((MaxLength)criterion);
        }
        return Optional.empty();
    }

    public ValidationResult validate(String value) {
        return this.allCriteriaSatisfied(value);
    }

    private ValidationResult allCriteriaSatisfied(String value) {
        for (Criterion criterion : this.criteria) {
            ValidationResult vr = criterion.validate(value);
            if (vr.isValid()) continue;
            return vr;
        }
        return ValidationResult.ok();
    }
}

