/*
 * Decompiled with CFR 0.152.
 */
package jwebform.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.ElementResult;
import jwebform.element.structure.GroupType;
import jwebform.element.structure.SingleType;
import jwebform.env.Env;
import jwebform.processors.CheckDoubleElementsPostProcessor;
import jwebform.processors.ElementResults;
import jwebform.processors.ElementValdationResults;
import jwebform.processors.PostProcessor;
import jwebform.validation.FormValidator;
import jwebform.validation.ValidationResult;

public class Processor {
    public final ElementResults run(Env.EnvWithSubmitInfo envWithSubmitInfo, GroupType group) {
        ElementResults elementResults = this.processElements(envWithSubmitInfo, group.getChilds());
        elementResults = this.runPostProcessors(elementResults);
        ElementValdationResults overridenValidationResults = this.runFormValidations(elementResults, group.getValidators(group.of()));
        return this.correctElementResults(elementResults, overridenValidationResults);
    }

    public ElementResults processElements(Env.EnvWithSubmitInfo env, ElementContainer ... elementsToProcess) {
        return this.processElements(env, Processor.packElementContainerInList(elementsToProcess));
    }

    private List<PostProcessor> getPostProcessors() {
        return Collections.singletonList(new CheckDoubleElementsPostProcessor());
    }

    private ElementResults runPostProcessors(ElementResults elementResults) {
        for (PostProcessor postProcessor : this.getPostProcessors()) {
            elementResults = postProcessor.postProcess(elementResults);
        }
        return elementResults;
    }

    private ElementResults processElements(Env.EnvWithSubmitInfo env, List<ElementContainer> elements) {
        ElementResults elementResults = new ElementResults();
        for (ElementContainer container : elements) {
            if (container.element instanceof GroupType) {
                this.processGroup(env, elementResults, container);
                continue;
            }
            this.proessSingleElement(env, elementResults, container);
        }
        return elementResults;
    }

    private void proessSingleElement(Env.EnvWithSubmitInfo env, ElementResults elementResults, ElementContainer container) {
        ElementResult result = ((SingleType)container.element).apply(env);
        if (env.isSubmitted() && result.getValidationResult() == ValidationResult.undefined()) {
            result = result.ofValidationResult(container.validator.validate(result.getValue()));
        }
        if (elementResults.containsElement(container)) {
            throw new IdenticalElementException(container);
        }
        elementResults.put(container, result);
    }

    private void processGroup(Env.EnvWithSubmitInfo env, ElementResults elementResults, ElementContainer container) {
        ElementResults groupElementResults = this.run(env, (GroupType)container.element);
        ElementResult groupResult = ((GroupType)container.element).process(env, groupElementResults);
        elementResults.put(container, groupResult.cloneWithChilds(groupElementResults));
    }

    private ElementValdationResults runFormValidations(ElementResults elementResults, List<FormValidator> formValidators) {
        ElementValdationResults overridenValidationResults = new ElementValdationResults();
        for (FormValidator formValidator : formValidators) {
            overridenValidationResults.merge(formValidator.validate(elementResults));
        }
        return overridenValidationResults;
    }

    public boolean checkAllValidationResults(ElementResults correctedElementResults) {
        boolean formIsValid = true;
        for (Map.Entry<ElementContainer, ElementResult> entry : correctedElementResults) {
            if (entry.getValue().getValidationResult() == ValidationResult.ok()) continue;
            formIsValid = false;
            break;
        }
        return formIsValid;
    }

    private ElementResults correctElementResults(ElementResults elementResults, ElementValdationResults overridenValidationResults) {
        overridenValidationResults.getResutls().forEach((element, overridenValidationResult) -> {
            ElementResult re = elementResults.get((ElementContainer)element);
            elementResults.put((ElementContainer)element, re.cloneWithNewValidationResult((ValidationResult)overridenValidationResult));
        });
        return elementResults;
    }

    private static List<ElementContainer> packElementContainerInList(ElementContainer ... elements) {
        ArrayList<ElementContainer> ec = new ArrayList<ElementContainer>();
        Collections.addAll(ec, elements);
        return ec;
    }

    public class IdenticalElementException
    extends RuntimeException {
        public IdenticalElementException(ElementContainer container) {
            super("Identical Elements are not allowed. Plese remove double container: " + container.element);
        }
    }
}

