/*
 * Decompiled with CFR 0.152.
 */
package jwebform.processors;

import jwebform.FormResult;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.ElementResult;
import jwebform.element.structure.SingleType;
import jwebform.processors.ElementResults;
import jwebform.processors.Logger;

public class LoggingFormResult
extends FormResult {
    public LoggingFormResult(String formId, ElementResults elementResults, boolean formIsValid) {
        super(formId, elementResults, formIsValid);
    }

    public void logForm(Logger logger) {
        StringBuilder b = new StringBuilder("\n");
        this.debugOutput(this.getElementResults(), b, "");
        logger.log(b.toString());
    }

    private String debugOutput(ElementResults elementResults, StringBuilder b, String indent) {
        elementResults.forEach(entry -> {
            ElementContainer container = (ElementContainer)entry.getKey();
            ElementResult result = (ElementResult)entry.getValue();
            if (container.element instanceof SingleType) {
                this.appendSingleType(b, container, result, indent);
            } else {
                this.appendSingleType(b, container, result, indent);
                this.debugOutput(result.getChilds(), b, indent + "---- ");
            }
        });
        return "Form valid: " + this.isOk() + "\n " + b.toString();
    }

    private void appendSingleType(StringBuilder b, ElementContainer container, ElementResult result, String indent) {
        b.append("---------------------\n").append(indent).append("Typ    : ").append(container.element.getClass().getName()).append("\n").append(indent).append("Name   : ").append(result.getStaticElementInfo().getName()).append("\n").append(indent).append("Value  : ").append(result.getValue()).append("\n").append(indent).append("Valdid : ").append(result.getValidationResult().isValid() ? "OK" : "Not OK").append("\n");
    }
}

