/*
 * Decompiled with CFR 0.152.
 */
package jwebform.processors;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.ElementResult;
import jwebform.processors.ElementValdationResults;
import jwebform.validation.ValidationResult;

public class ElementResults
implements Iterable<Map.Entry<ElementContainer, ElementResult>> {
    private final Map<ElementContainer, ElementResult> elementResultMap;

    public ElementResults(Map<ElementContainer, ElementResult> elementResultMap) {
        this.elementResultMap = elementResultMap;
    }

    public ElementResults() {
        this.elementResultMap = new LinkedHashMap<ElementContainer, ElementResult>();
    }

    public void put(ElementContainer container, ElementResult result) {
        this.elementResultMap.put(container, result);
    }

    public boolean containsElement(ElementContainer container) {
        return this.elementResultMap.containsKey(container);
    }

    public ElementResult get(ElementContainer element) {
        return this.elementResultMap.get(element);
    }

    @Override
    public Iterator<Map.Entry<ElementContainer, ElementResult>> iterator() {
        return this.elementResultMap.entrySet().iterator();
    }

    public String getElementStringValue(String elementName) {
        for (ElementResult i : this.elementResultMap.values()) {
            if (!elementName.equals(i.getStaticElementInfo().getName())) continue;
            return i.getValue();
        }
        throw new IllegalArgumentException(String.format("The element named %s does not exist in form", elementName));
    }

    public final Object getObectValue(String elementName) {
        for (ElementResult i : this.elementResultMap.values()) {
            if (!elementName.equals(i.getStaticElementInfo().getName())) continue;
            return i.getValueObject();
        }
        throw new ElementNotFoundException("This element does not exist in form", elementName);
    }

    public final ElementValdationResults computeSingleElementValidation(String elementName, ValidationResult vr) {
        return ElementValdationResults.of(this.getElement(elementName), vr);
    }

    public ElementContainer getElement(String elementName) {
        for (Map.Entry<ElementContainer, ElementResult> entry : this.elementResultMap.entrySet()) {
            if (!elementName.equals(entry.getValue().getStaticElementInfo().getName())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("This name is not within the form!");
    }

    public Object size() {
        return this.elementResultMap.size();
    }

    public Set<ElementContainer> getContainers() {
        return this.elementResultMap.keySet();
    }

    public class ElementNotFoundException
    extends RuntimeException {
        private final String elementName;

        public ElementNotFoundException(String msg, String elementName) {
            super(msg);
            this.elementName = elementName;
        }

        public String getElementName() {
            return this.elementName;
        }
    }
}

